#ifndef WTIMPORT_H
#define WTIMPORT_H

#include "epub.h"
#include "internet.h"
#include "jwpub.h"
#include "xml_reader.h"
#include "sharedlib_global.h"

class TB_EXPORT wtimport : public QObject
{
    Q_OBJECT

public:
    explicit wtimport(QObject *parent = nullptr);
    explicit wtimport(QString fileName, QObject *parent = nullptr);
    QString Import();
    Q_INVOKABLE QString importFile(const QString fileName);
    Q_INVOKABLE QString importHtml(const QString url, QString html);
    Q_INVOKABLE QString getDocumentId(QDate date);
    Q_INVOKABLE void exportAssistFiles(); // doesn't belong in a class with "import" in the name, but we'll move it later :)

    enum xmlPartsContexts {
        groupTOC,
        studyArticleInfo,
        studyArticleDocIdPar,
        studyArticleDocId,
        header,
        h1,
        article,
        title,
        song
    };
    Q_ENUM(xmlPartsContexts)

    enum rxLoadStates {
        noLoadAttempt,
        attempted,
        loaded
    };

    QHash<QString, QString> regexes;
    epub epb;
    bool prepared;
    QString lastError;

signals:

public slots:
    void ProcessTOCEntry(QString href, QString chapter);
    void xmlPartFound(QXmlStreamReader *xml, QXmlStreamReader::TokenType tokenType, int context, int relativeDepth);
    void ProcessCoverImage(QString fileName);

private:
    void init(QString fileName);
    bool downloadArticleDates();
    void addArticleDate(int documentId, QDate dt, int articleNr);
    void loadArticleDates(int year);
    QDate getDate(QStringView value);
    QString resultText();
    QString readRuby(QXmlStreamReader *xml);
    QString readInnerText(QXmlStreamReader *xml);

    sql_class *sql;
    int year;
    int month;
    int validDates;
    QString firstDate;
    QString lastDate;
    int rxLoadState;
    QRegularExpression rxDate;
    QRegularExpression rxSong;
    QMap<int, QDate> articleDates;
    int queueOpenSong;
    int queueCloseSong;
    QDate queueArticle_Date;
    int queueArticle_DocId;
    int queueArticle_Number;
    QString queueTheme;
    QString htmldata;
    QHash<QDate, QString> wtDocumentIds;
};

#endif // WTIMPORT_H
