#ifndef UNAVAILABILITY_H
#define UNAVAILABILITY_H

#include <QAbstractListModel>
#include <QObjectBindableProperty>
#include <QSortFilterProxyModel>
#include <QValidator>
#include "sql_class.h"

class Unavailability : public QObject
{
    Q_OBJECT
    Q_PROPERTY(int unavailabilityId READ unavailabilityId BINDABLE bindableUnavailabilityId)
    Q_PROPERTY(int personId READ personId WRITE setPersonId BINDABLE bindablePersonId)
    Q_PROPERTY(QDate startDate READ startDate WRITE setStartDate BINDABLE bindableStartDate)
    Q_PROPERTY(QDate endDate READ endDate WRITE setEndDate BINDABLE bindableEndDate)
    Q_PROPERTY(bool isDirty READ isDirty WRITE setIsDirty BINDABLE bindableIsDirty)
public:
    Unavailability(QObject *parent = nullptr);
    Unavailability(const int id, const int personId, const QDate startDate, const QDate endDate, QObject *parent);

    int unavailabilityId() { return b_unavailabilityId.value(); }
    void setUnavailabilityId(int newValue) { b_unavailabilityId = newValue; }
    QBindable<int> bindableUnavailabilityId() { return &b_unavailabilityId; }

    int personId() { return b_personId.value(); }
    void setPersonId(int newValue) { b_personId = newValue; }
    QBindable<int> bindablePersonId() { return &b_personId; }

    QDate startDate() { return b_startDate.value(); }
    void setStartDate(QDate newValue) { b_startDate = newValue; }
    QBindable<QDate> bindableStartDate() { return &b_startDate; }

    QDate endDate() { return b_endDate.value(); }
    void setEndDate(QDate newValue) { b_endDate = newValue; }
    QBindable<QDate> bindableEndDate() { return &b_endDate; }

    bool isDirty() { return b_isDirty.value(); }
    void setIsDirty(bool newValue) { b_isDirty = newValue; }
    QBindable<bool> bindableIsDirty() { return &b_isDirty; }

    bool save();

signals:
    void unavailabilityIdChanged();
    void personIdChanged();
    void startDateChanged();
    void endDateChanged();
    void isDirtyChanged();

private:
    Q_OBJECT_BINDABLE_PROPERTY(Unavailability, int, b_unavailabilityId, &Unavailability::unavailabilityIdChanged);
    Q_OBJECT_BINDABLE_PROPERTY(Unavailability, int, b_personId, &Unavailability::personIdChanged);
    Q_OBJECT_BINDABLE_PROPERTY(Unavailability, QDate, b_startDate, &Unavailability::startDateChanged);
    Q_OBJECT_BINDABLE_PROPERTY(Unavailability, QDate, b_endDate, &Unavailability::endDateChanged);
    QProperty<bool> b_isDirty { false };
};

class UnavailabilityModel : public QAbstractTableModel
{
    Q_OBJECT

    Q_PROPERTY(int length READ rowCount NOTIFY modelChanged)
public:
    explicit UnavailabilityModel(QObject *parent = nullptr);
    ~UnavailabilityModel();

    enum Roles {
        None = 0,
        UnavailabilityIdRole = Qt::UserRole,
        UnavailabilityRole,
        PersonIdRole,
        StartDateRole,
        EndDateRole,
        YearRole
    };
    Q_ENUM(Roles)

    QHash<int, QByteArray> roleNames() const override;

    int rowCount(const QModelIndex &parent = QModelIndex()) const override;
    int columnCount(const QModelIndex &parent = QModelIndex()) const override;

    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const override;

    Q_INVOKABLE QVariantMap get(int row) const;
    Q_INVOKABLE bool setData(const QModelIndex &index, const QVariant &value, int role = Qt::EditRole) override;

    Q_INVOKABLE QModelIndex getUnavailabilityIndex(int unavailabilityId) const;
    Q_INVOKABLE QModelIndex getUnavailabilityIndex(int personId, QDate startDate, QDate endDate) const;
    int addUnavailability(Unavailability *Unavailability);
    Q_INVOKABLE QModelIndex addUnavailability(int personId);
    Q_INVOKABLE void removeUnavailability(int unavailabilityId);
    Q_INVOKABLE void removeUnavailability(int personId, QDate startDate, QDate endDate);
    Q_INVOKABLE void loadUnavailabilities(int personId);
    Q_INVOKABLE bool isUnavailable(QDate date);
    Q_INVOKABLE void save();
signals:
    void modelChanged();

private:
    QList<Unavailability *> unavailabilities;
};

class UnavailabilitySortFilterProxyModel : public QSortFilterProxyModel
{
    Q_OBJECT
    Q_PROPERTY(QObject *source READ source WRITE setSource NOTIFY sourceChanged)
    Q_PROPERTY(QByteArray sortRole READ sortRole WRITE setSortRole NOTIFY sortChanged)

public:
    UnavailabilitySortFilterProxyModel(QObject *parent = nullptr);

    QObject *source() const;
    void setSource(QObject *source);

    QByteArray sortRole() const;
    void setSortRole(const QByteArray &role);

    Q_INVOKABLE virtual void sort(int column, Qt::SortOrder order = Qt::AscendingOrder) override
    {
        QSortFilterProxyModel::sort(column, order);
    }

protected:
    bool lessThan(const QModelIndex &left, const QModelIndex &right) const override;
    int roleKey(const QByteArray &role) const;

private:
    QString m_filterText;
    QByteArray m_groupByRole;

signals:
    void sourceChanged();
    void sortChanged();
};

class UnavailabilityValidator : public QValidator
{
    Q_OBJECT
    Q_PROPERTY(UnavailabilityModel *model READ model WRITE setModel NOTIFY modelChanged)
    Q_PROPERTY(int unavailabilityId READ unavailabilityId WRITE setUnavailabilityId BINDABLE bindableUnavailabilityId)
    Q_PROPERTY(UnavailabilityModel::Roles role READ role WRITE setRole NOTIFY roleChanged)
public:
    UnavailabilityValidator(QObject *parent = nullptr);
    ~UnavailabilityValidator();

    QValidator::State validate(QString &input, int &pos) const override;

    UnavailabilityModel *model() const;
    void setModel(UnavailabilityModel *newModel);

    int unavailabilityId() const { return b_unavailabilityId.value(); }
    void setUnavailabilityId(int newValue) { b_unavailabilityId = newValue; }
    QBindable<int> bindableUnavailabilityId() { return &b_unavailabilityId; }

    UnavailabilityModel::Roles role() const;
    void setRole(UnavailabilityModel::Roles newRole);

signals:
    void modelChanged();
    void unavailabilityIdChanged();
    void roleChanged();
    void errorChanged(const QString &error) const;

private:
    UnavailabilityModel *m_model;
    Q_OBJECT_BINDABLE_PROPERTY(UnavailabilityValidator, int, b_unavailabilityId, &UnavailabilityValidator::unavailabilityIdChanged);
    UnavailabilityModel::Roles m_role;
};

#endif // UNAVAILABILITY_H
