# -------------------------------------------------
# Project created by QtCreator 2009-10-23T18:49:48
# -------------------------------------------------
!versionAtLeast(QT_VERSION, 6.10.0):error("Qt 6.10 required")

QT += widgets \
    sql \
    network \
    svg \
    printsupport \
    quickcontrols2 \
    quickwidgets \
    webchannel \
    webenginecore \
    webenginequick \
    webenginewidgets \
    positioning \
    location \
    xml \
    networkauth \
    help \
    core5compat \
    concurrent
TARGET = theocbase
TEMPLATE = app
VERSION = 2025.01.1
DEFINES += APP_VERSION=\\\"$$VERSION\\\"
DEFINES += TB_LIBRARY
DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060800

CONFIG -= qtquickcompiler
CONFIG += c++17

Release:DESTDIR = $${OUT_PWD}/release
Debug:DESTDIR = $${OUT_PWD}/debug
# QMAKE_CXX = ccache g++

macx {
QT += concurrent dbus sensors
    QMAKE_FRAMEWORK_BUNDLE_NAME = TheocBase
    TARGET = TheocBase
}

SOURCES += main.cpp \
    assignmentInfo.cpp \
    congregationdetail.cpp \
    dataobject.cpp \
    mainwindow.cpp \
    personComboBox.cpp \
    print/printcombination.cpp \
    print/printdocument.cpp \
    print/printhospitality.cpp \
    print/printmidweekschedule.cpp \
    print/printmidweekslip.cpp \
    print/printmidweekworksheet.cpp \
    print/printoutgoingassignment.cpp \
    print/printoutgoingschedule.cpp \
    print/printtalksofspeakerslist.cpp \
    print/printterritoryassignmentrecord.cpp \
    print/printterritorycard.cpp \
    print/printterritorymapcard.cpp \
    print/printweekendschedule.cpp \
    print/printweekendworksheet.cpp \
    profiles.cpp \
    publictalk.cpp \
    publictalkdetail.cpp \
    shareutils.cpp \
    specialevent.cpp \
    sql_class.cpp \
    settings.cpp \
    printui.cpp \
    person.cpp \
    persondetailmodel.cpp \
    sqlcombo.cpp \
    cpersons.cpp \
    personsui.cpp \
    checkupdates.cpp \
    ccongregation.cpp \
    generatexml.cpp \
    csync.cpp \
    historytable.cpp \
    single_application.cpp \
    cpublictalks.cpp \
    startup.cpp \
    logindialog.cpp \
    importwizard.cpp \
    reminders.cpp \
    ccloud.cpp \
    importwintm.cpp \
    schoolreminder.cpp \
    sync_cloud.cpp \
    printingconditionals.cpp \
    family.cpp \
    simplecrypt.cpp \
    googlemediator.cpp \
    googlemail.cpp \
    tbstyle.cpp \
    todo.cpp \
    file.cpp \
    lmm_assignment.cpp \
    lmm_assignment_ex.cpp \
    unavailability.cpp \
    weekinfo.cpp \
    lmm_meeting.cpp \
    lmm_schedule.cpp \
    lmm_assignmentcontoller.cpp \
    publicmeeting_controller.cpp \
    pdfform.cpp \
    lmmworksheetregex.cpp \
    talkTypeComboBox.cpp \
    slipscanner.cpp \
    ical.cpp \
    importTa1ks.cpp \
    importkhs.cpp \
    territorymanagement.cpp \
    territory.cpp \
    territoryassignment.cpp \
    dateeditbox.cpp \
    general.cpp \
    printpreview.cpp \
    cterritories.cpp \
    territoryaddress.cpp \
    territorystreet.cpp \
    availability/availabilitychecker.cpp \
    availability/tb_availability.cpp \
    availability/weekendmeetingavailabilitychecker.cpp \
    availability/midweekmeetingavailabilitychecker.cpp \
    lmmtalktypeedit.cpp \
    accesscontrol.cpp \
    cloud/cloud_controller.cpp \
    cloud/theocbaseoauth.cpp \
    cloud/storageservice.cpp \
    cloud/dropbox.cpp \
    cloud/nextcloud.cpp \
    helpviewer.cpp \
    printchannel.cpp \
    dropboxsyncbutton.cpp \
    todomodel.cpp \
    outgoingspeakersmodel.cpp \
    xml_reader.cpp \
    applyyourselfimport.cpp \
    epub.cpp \
    zipper.cpp \
    zip/qzip.cpp \
    wtimport.cpp \
    mapSettings.cpp \
    importlmmworkbook.cpp \
    jwpub.cpp \
    internet.cpp

HEADERS += mainwindow.h \
    dataobject.h \
    assignmentInfo.h \
    congregationdetail.h \
    personComboBox.h \
    print/printcombination.h \
    print/printdocument.h \
    print/printhospitality.h \
    print/printmidweekschedule.h \
    print/printmidweekslip.h \
    print/printmidweekworksheet.h \
    print/printoutgoingassignment.h \
    print/printoutgoingschedule.h \
    print/printtalksofspeakerslist.h \
    print/printterritoryassignmentrecord.h \
    print/printterritorycard.h \
    print/printterritorymapcard.h \
    print/printweekendschedule.h \
    print/printweekendworksheet.h \
    profiles.h \
    publictalk.h \
    publictalkdetail.h \
    sharedlib_global.h \
    shareutils.h \
    specialevent.h \
    sql_class.h \
    settings.h \
    printui.h \
    person.h \
    persondetailmodel.h \
    cpersons.h \
    personsui.h \
    checkupdates.h \
    ccongregation.h \
    generatexml.h \
    csync.h \
    constants.h \
    historytable.h \
    single_application.h \
    cpublictalks.h \
    startup.h \
    logindialog.h \
    importwizard.h \
    tbstyle.h \
    unavailability.h \
    weekinfo.h \
    reminders.h \
    ccloud.h \
    importwintm.h \
    schoolreminder.h \
    singleton.h \
    sync_cloud.h \
    printingconditionals.h \
    family.h \
    simplecrypt.h \
    googlemediator.h \
    googlemail.h \
    todo.h \
    file.h \
    lmm_assignment.h \
    lmm_assignment_ex.h \
    lmm_meeting.h \
    lmm_schedule.h \
    lmm_assignmentcontoller.h \
    sortfilterproxymodel.h \
    publicmeeting_controller.h \
    pdfform.h \
    lmmworksheetregex.h \
    talkTypeComboBox.h \
    slipscanner.h \
    ical.h \
    importTa1ks.h \
    importkhs.h \
    territorymanagement.h \
    territory.h \
    territoryassignment.h \
    dateeditbox.h \
    general.h \
    printpreview.h \
    cterritories.h \
    territoryaddress.h \
    territorystreet.h \
    availability/availabilitychecker.h \
    availability/tb_availability.h \
    availability/weekendmeetingavailabilitychecker.h \
    availability/midweekmeetingavailabilitychecker.h \
    lmmtalktypeedit.h \
    accesscontrol.h \
    cloud/cloud_controller.h \
    cloud/theocbaseoauth.h \
    cloud/storageservice.h \
    cloud/dropbox.h \
    cloud/nextcloud.h \
    helpviewer.h \
    printchannel.h \
    dropboxsyncbutton.h \
    todomodel.h \
    outgoingspeakersmodel.h \
    xml_reader.h \
    applyyourselfimport.h \
    epub.h \
    zipper.h \
    zip/qzipreader_p.h \
    zip/qzipwriter_p.h \
    wtimport.h \
    mapSettings.h \
    importlmmworkbook.h \
    jwpub.h \
    internet.h

FORMS += mainwindow.ui \
    settings.ui \
    printui.ui \
    personsui.ui \
    historytable.ui \
    startup.ui \
    logindialog.ui \
    importwizard.ui \
    reminders.ui \
    lmmworksheetregex.ui \
    territorymanagement.ui \
    printpreview.ui \
    lmmtalktypeedit.ui
RESOURCES += images.qrc \
    database.qrc \
    osmRepository.qrc \
    startup.qrc \
    qml.qrc \
    fonts/fonts.qrc
ICON = images/theocbase.icns
RC_FILE = theocbase.rc

TRANSLATIONS = translations/theocbase_en.ts \
    translations/theocbase_ru.ts \
    translations/theocbase_hu.ts \
    translations/theocbase_pt.ts \
    translations/theocbase_el.ts \
    translations/theocbase_de.ts \
    translations/theocbase_fr.ts \
    translations/theocbase_nl.ts \
    translations/theocbase_it.ts \
    translations/theocbase_es.ts \
    translations/theocbase_et.ts \
    translations/theocbase_ro.ts \
    translations/theocbase_af.ts \
    translations/theocbase_sv.ts \
    translations/theocbase_hr.ts \
    translations/theocbase_pl.ts \
    translations/theocbase_da.ts \
    translations/theocbase_sk.ts \
    translations/theocbase_cs.ts \
    translations/theocbase_ka.ts \
    translations/theocbase_fi.ts \
    translations/theocbase_lt.ts \
    translations/theocbase_no.ts \
    translations/theocbase_ht.ts \
    translations/theocbase_bg.ts \
    translations/theocbase_uk.ts \
    translations/theocbase_pt_BR.ts \
    translations/theocbase_my_MM.ts \
    translations/theocbase_sl.ts \
    translations/theocbase_zh.ts \
    translations/theocbase_gn.ts \
    translations/theocbase_pa.ts \
    translations/theocbase_pa_PK.ts \
    translations/theocbase_sr.ts \
    translations/theocbase_sw.ts \
    translations/theocbase_ta.ts \
    translations/theocbase_th_TH.ts \
    translations/theocbase_tl.ts \
    translations/theocbase_cpf_gcf.ts \
    translations/theocbase_hy.ts \
    translations/theocbase_ne.ts \
    translations/theocbase_he.ts \
    translations/theocbase_hi.ts \
    translations/theocbase_ee.ts \
    translations/theocbase_cpe_011.ts \
    translations/theocbase_xh.ts \
    translations/theocbase_az_AZ.ts \
    translations/theocbase_tr_TR.ts \
    translations/theocbase_de_LU.ts
OTHER_FILES += \
    changelog.txt \
    ../update.xml \
    ../update.ini \

lupdate_only{
HEADERS = \
    *.h \
    print/*.h
SOURCES = \
    *.cpp \
    print/*.cpp \
    qml/*.qml \
    qml/controls/*.qml \
    qml/controls/+fusion/*.qml \
    qml/controls/+material/*.qml \
    qml/controls/+universal/*.qml
}

macx {
    LIBS += -framework AppKit
    LIBS += -lz
    HEADERS += macos/machelper.h \
        macos/macshareutils.h
    OBJECTIVE_SOURCES += macos/machelper.mm \
        macos/macshareutils.mm
    QMAKE_INFO_PLIST = Info.plist
    OTHER_FILES += Info.plist
    # translation files
    qmFiles.files = $$files(translations/*.qm)
    qmFiles.path = Contents/Resources
    QMAKE_BUNDLE_DATA += qmFiles
    # templates
    MacTemplates.files = ../templates
    MacTemplates.path = Contents/Resources
    QMAKE_BUNDLE_DATA += MacTemplates
    # auto updater
    exists(../bitrock/autoupdate-osx.app) {
        message("Add autoupdater...")
        MacAutoUpdater.files = ../bitrock/autoupdate-osx.app \
                               ../update.ini
        MacAutoUpdater.path = Contents/MacOS
        QMAKE_BUNDLE_DATA += MacAutoUpdater
    }
    # documentation files
    message("Add doc files...")
    docFiles.files = $$files(../docs/*.qhc)
    docFiles.files += $$files(../docs/*.qch)
    docFiles.path = Contents/Resources/docs
    QMAKE_BUNDLE_DATA += docFiles
} else {
    templFiles.files = ../templates/*
    templFiles.path = $${DESTDIR}/templates
    INSTALLS += templFiles
    docFiles.files = ../docs/*
    docFiles.path = $${DESTDIR}/docs
    INSTALLS += docFiles
    languageFiles.files = *.qm
    languageFiles.path = $${DESTDIR}
    INSTALLS += languageFiles
}
win32 {
    HEADERS += windows/windowsshareutils.h
    SOURCES += windows/windowsshareutils.cpp
}
unix: LIBS += -lz

# SMTP Client
include(smtp/smtpclient.pri)

# GDAL
unix:!macx {
    LIBS += -L$$PWD/../lib/ -lgdal
}
macx {
    LIBS += -L/opt/homebrew/Cellar/gdal/3.10.0_1/lib -lgdal
    #LIBS += -L/usr/local/Cellar/gdal/3.9.2_2/lib -lgdal
    #INCLUDEPATH += /usr/local/Cellar/gdal/3.9.2_2/include
    INCLUDEPATH += /opt/homebrew/Cellar/gdal/3.10.0_1/include
    #LIBS += -F/Library/Frameworks/ -framework GDAL
    #INCLUDEPATH += /Library/Frameworks/GDAL.framework/Headers
}

win32 {
    # GDAL for Windows
    !contains(QMAKE_TARGET.arch, x86_64) {
        # 32-bit
        LIBS += -L$$PWD/../lib/gdal32/lib/ -lgdal_i
        INCLUDEPATH += $$PWD/../lib/gdal32/include
        DEPENDPATH += $$PWD/../lib/gdal32/include
    } else {
        # 64-bit
        LIBS += -L$$PWD/../lib/gdal64/lib/ -lgdal_i
        INCLUDEPATH += $$PWD/../lib/gdal64/include
        DEPENDPATH += $$PWD/../lib/gdal64/include
    }
}
