/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2016, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TERRITORYMANAGEMENT_H
#define TERRITORYMANAGEMENT_H

#include <QDialog>
#include <QQmlContext>
#include <QQmlFileSelector>
#include "cterritories.h"
#include "territory.h"
#include "territoryassignment.h"
#include "territorystreet.h"
#include "territoryaddress.h"

namespace Ui {
class territorymanagement;
}

class territorymanagement : public QDialog
{
    Q_OBJECT

public:
    explicit territorymanagement(QWidget *parent = nullptr);
    ~territorymanagement();

protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void on_buttonBox_clicked(QAbstractButton *button);

private:
    Ui::territorymanagement *ui;
    sql_class *sql;
    AccessControl *ac;
    TerritoryTreeModel *territoryTreeModel;
    TerritoryAssignmentModel *assignmentModel;
    TerritoryAddressModel *addressModel;
    DataObjectListModel *typeListModel;
    DataObjectListModel *cityListModel;
    TerritoryStreetModel *streetModel;
};

#endif // TERRITORYMANAGEMENT_H
