/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2016, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "territorymanagement.h"
#include "ui_territorymanagement.h"

territorymanagement::territorymanagement(QWidget *parent)
    : QDialog(parent), ui(new Ui::territorymanagement)
{
    sql = &Singleton<sql_class>::Instance();
    ac = &Singleton<AccessControl>::Instance();

    ui->setupUi(this);

    // territory-treeview
    territoryTreeModel = new TerritoryTreeModel();

    // list of territory-types
    sql_items typeItems = sql->selectSql("SELECT * FROM territory_type WHERE active = 1 ORDER BY id;");
    typeListModel = new DataObjectListModel();
    typeListModel->addDataObject(DataObject(-1, " "));
    for (unsigned int i = 0; i < typeItems.size(); i++) {
        typeListModel->addDataObject(DataObject(typeItems[i].value("id").toInt(),
                                                typeItems[i].value("type_name").toString()));
    }

    // list of cities
    sql_items cityItems = sql->selectSql("SELECT * FROM territory_city WHERE active = 1 ORDER BY city;");
    cityListModel = new DataObjectListModel();
    cityListModel->addDataObject(DataObject(-1, " "));
    for (unsigned int i = 0; i < cityItems.size(); i++) {
        cityListModel->addDataObject(DataObject(cityItems[i].value("id").toInt(),
                                                cityItems[i].value("city").toString()));
    }

    // assignments
    assignmentModel = new TerritoryAssignmentModel();
    TerritoryAssignmentSortFilterProxyModel *assignmentProxyModel = new TerritoryAssignmentSortFilterProxyModel(this);
    assignmentProxyModel->setSourceModel(assignmentModel);

    // streets
    streetModel = new TerritoryStreetModel();
    TerritoryStreetSortFilterProxyModel *streetProxyModel = new TerritoryStreetSortFilterProxyModel(this);
    streetProxyModel->setSourceModel(streetModel);

    // addresses
    addressModel = new TerritoryAddressModel();
    TerritoryAddressSortFilterProxyModel *addressProxyModel = new TerritoryAddressSortFilterProxyModel(this);
    addressProxyModel->setSourceModel(addressModel);

    QSettings settings;
    int defaultGeoServiceProvider = settings.value("geo_service_provider/default", 0).toInt();
    // set plugin parameters for the map, and use OSM (0) when Google (1) is sele cted as default
    const QStringList geoServiceProviders{"osm", "osm", "here"};
    auto defaultGeoServiceProviderName = geoServiceProviders[defaultGeoServiceProvider];

    cterritories *t = new cterritories;
    QVariantMap geoServiceParameters = t->setupGeoServices(defaultGeoServiceProvider);

    QQmlContext *ctxt = ui->quickWidget->rootContext();
    ctxt->setContextProperty("accessControl", ac);
    ctxt->setContextProperty("territoryTreeModel", territoryTreeModel);
    ctxt->setContextProperty("typeListModel", typeListModel);
    ctxt->setContextProperty("cityListModel", cityListModel);
    ctxt->setContextProperty("assignmentModel", assignmentModel);
    ctxt->setContextProperty("assignmentProxyModel", assignmentProxyModel);
    ctxt->setContextProperty("streetModel", streetModel);
    ctxt->setContextProperty("streetProxyModel", streetProxyModel);
    ctxt->setContextProperty("addressModel", addressModel);
    ctxt->setContextProperty("addressProxyModel", addressProxyModel);
    ctxt->setContextProperty("mainWindow", parent);
    ctxt->setContextProperty("defaultGeoServiceProvider", defaultGeoServiceProviderName);
    ctxt->setContextProperty("geoServiceParameters", QVariant::fromValue(geoServiceParameters));
#if defined(Q_OS_LINUX) || defined(Q_OS_MAC) || defined(Q_OS_WIN)
    ctxt->setContextProperty("isGdalAvailable", true);
#endif

    ui->quickWidget->setAttribute(Qt::WA_AlwaysStackOnTop);
    ui->quickWidget->setClearColor(Qt::transparent);
    new QQmlFileSelector(ui->quickWidget->engine(), ui->quickWidget);
    ui->quickWidget->setSource(QUrl("qrc:/qml/TerritoryManager.qml"));

    ui->buttonBox->setVisible(false);
}

territorymanagement::~territorymanagement()
{
    delete ui;
}

void territorymanagement::closeEvent(QCloseEvent *event)
{
    event->accept();
}

void territorymanagement::on_buttonBox_clicked(QAbstractButton *button)
{
    Q_UNUSED(button)
}
