import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtWebEngine
import net.theocbase 1.0
import "../qml/controls"

Frame {
    id: rectangle
    width: 480
    height: 640
    visible: true

    signal close()
    signal newsFound()

    Page {
        anchors.fill: parent

        header: RowLayout {
            Item {
                Layout.fillWidth: true
                Layout.margins: 30
                Label {
                    anchors.centerIn: parent
                    horizontalAlignment: Text.AlignHCenter
                    text: qsTr("Welcome to theocbase")
                    font: TBStyle.titleLargeFont
                }
            }
            RoundButton {
                Layout.alignment: Qt.AlignVCenter
                icon.source: "qrc:/icons/close.svg"
                onClicked: close()
            }
        }

        WebEngineView {
            id: webView
            anchors.fill: parent

            url: "https://www.theocbase.net/appnews.html"

            onLoadingChanged: function(loadRequest) {
                if (loadRequest.status === WebEngineView.LoadSucceededStatus) {
                    if (settings_ui.latestArticle !== webView.title) {
                        settings_ui.latestArticle = webView.title
                        console.log("title saved " + webView.title)
                        newsFound()
                    }
                }
                if (loadRequest.errorString)
                    console.error(loadRequest.errorString);
            }
        }
        BusyIndicator {
            id: busyIndicator
            z: 2
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter

            palette.text: "black"
            running: webView.loading
        }

        footer: RowLayout {
            CheckBox {
                id: checkBox
                Layout.alignment: Qt.AlignVCenter
                Layout.topMargin: 10
                text: qsTr("Do not show again")
                onToggled: settings_ui.show_start_page = !checkBox.checked
                checked: !settings_ui.show_start_page
            }
        }
    }
}
