import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Universal
import QtQuick.Window
import QtQuick.Layouts
import net.theocbase 1.0

Item {
    id: sidebar

    Universal.theme: Universal.System

    property bool isVisible: false
    property string hintText: qsTr("Select an assignment on the left to edit")

    function loadPage(filename, args)
    {
        root.forceActiveFocus()
        if (filename === "")
            sidebarLoader.source = ""
        else
            sidebarLoader.setSource(filename, args)
    }

    Label {
        anchors.fill: parent
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.WordWrap
        text: sidebar.hintText
        visible: parent.width > 0 && sidebarLoader.source === ""
    }

    Loader {
        id: sidebarLoader
        anchors.fill: parent
        onSourceChanged: {
            if (source === "" && isVisible)
                isVisible = false
        }
        onLoaded: {
            console.log("sidebar content loaded")
        }
    }
}
