/**
 * This file is an interim solution for the Icon control provided in Qt 6.9
 */
import QtQuick
import QtQuick.Controls.Universal
import QtQuick.Effects

Item {
    id: control
    width: 24
    height: 24

    property string source: ""
    property color color: Universal.foreground
    property int fillMode: Image.PreserveAspectFit
    property alias hovered: hoverHandler.hovered

    HoverHandler { id: hoverHandler }

    Image {
        id: sourceImage
        source: control.source
        sourceSize: Qt.size(control.width, control.height)
        fillMode: control.fillMode
        visible: false
    }

    MultiEffect {
        source: sourceImage
        anchors.fill: parent
        colorization: 1
        colorizationColor: control.color
    }
}
