/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the Qt Quick Controls 2 module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL3$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPLv3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or later as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file. Please review the following information to
** ensure the GNU General Public License version 2.0 requirements will be
** met: http://www.gnu.org/licenses/gpl-2.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick.Controls
import QtQuick.Controls.impl
import QtQuick.Controls.Material
import QtQuick.Controls.Material.impl
import net.theocbase 1.0
import "./"

TextField {
    id: control

    property string error
    property date selectedDate
    property bool isButtonVisible: true
    property bool isClearButtonVisible: false

    signal clearTriggered()

    leftPadding: acceptableInput ? 6 : 27

    ToolTip.visible: ToolTip.text !== "" && hovered
    ToolTip.text: error

    AlertIndicator {
        id: errorIndicator

        x: 3
        y: 5
        visible: !parent.acceptableInput

        states:
            [
            State {
                name: "Valid"; when: acceptableInput
                PropertyChanges { target: errorIndicator; scale: 1.2; }
            },
            State {
                name: "Invalid"; when: !acceptableInput
                PropertyChanges { target: errorIndicator; scale: 1; }
            }
        ]

        transitions: Transition {
            NumberAnimation {
                properties: "scale"
                from: 1.2;
                to: 1;
                duration: 100
                loops: 2
            }
        }
    }

    IconImage {
        id: clearText
        anchors { top: parent.top; right: parent.right; margins: 12; rightMargin: indicator.width }
        fillMode: Image.PreserveAspectFit
        smooth: true
        visible: isClearButtonVisible && control.enabled && (control.editable ? control.editText : control.displayText)
        source: "qrc:///icons/backspace.svg"
        color: Material.foreground
        mirror: Qt.application.layoutDirection === Qt.RightToLeft

        height: 20
        width: 20

        MouseArea {
            id: clear
            anchors.fill: parent
            onClicked: clearTriggered()
        }
    }

    Rectangle {
        id: calendarButton
        anchors { left: parent.right}
        y: control.topPadding
        height: parent.height - 20
        width: parent.height - 20
        color: "transparent"
        visible: control.isButtonVisible

        IconImage {
            anchors.fill: parent
            anchors.margins: 0

            color: myPalette.windowText
            source: "qrc:/icons/calendar_month.svg"
        }

        MouseArea {
            anchors.fill: parent
            onClicked: {
                cal.selectedDate = isNaN(control.selectedDate.getTime()) ? new Date() : control.selectedDate;
                cal.open();
            }
        }
    }

    CalendarPopup {
        id: cal
        margins: 10
        onActivated: {
            control.selectedDate = this.selectedDate
        }
    }
}
