import QtCore
import QtQuick
import QtQuick.Window
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase 1.0
import "controls"
import "sidePanelScripts.js" as SPScripts

Page {
    id: unavailabilityPage

    // PROPERTY DECLARATIONS
    property Unavailability unavailability
    property bool isDateLoading: true
    property string dateFormat: Qt.locale().dateFormat(Locale.ShortFormat)

    signal pageCanceled()

    // OBJECT PROPERTIES
    Layout.fillWidth: true
    Layout.fillHeight: true

    header: RowLayout {
        ToolButton {
            Layout.alignment: Qt.AlignRight
            icon.source: "qrc:/icons/chevron_left.svg"
            enabled: unavailability
                     && !isNaN(unavailability.startDate.getTime())
                     && !isNaN(unavailability.endDate.getTime())
                     && !endDateErrorLabel.visible
            onClicked: {
                unavailabilityModel.save();
                // reload list due to dependencies to other rows
                // when validating the time ranges of unavailabilities
                loadUnavailabilities(currentPerson.id);
                unavailabilityEditStack.pop();
            }
        }
        Label {
            Layout.fillWidth: true
            text: qsTr("Edit unavailability")
            font: TBStyle.titleSmallFont
        }
        ToolButton {
            Layout.alignment: Qt.AlignRight
            icon.source: "qrc:/icons/close.svg"
            onClicked: {
                unavailabilityEditStack.pop();
                pageCanceled();
            }
        }
    }

    Component.onCompleted: {
        console.log("unavailability: " + unavailability);
    }

    onUnavailabilityChanged: {
        console.log("unavailability changed: " + unavailability);
        if (unavailability) {
            if (!isNaN(unavailability.startDate.getTime()))
                startDateEdit.selectedDate = unavailability.startDate;
            if (!isNaN(unavailability.endDate.getTime()))
                endDateEdit.selectedDate = unavailability.endDate;
        }
    }

    // CHILD OBJECTS
    UnavailabilityValidator {
        id: endDateValidator
        model: unavailabilityModel
        unavailabilityId: unavailability ? unavailability.unavailabilityId : 0
        role: UnavailabilityModel.EndDateRole
        onErrorChanged: function(error) { endDateErrorLabel.text = error }
        onUnavailabilityIdChanged: {
            isDateLoading = true;
            isDateLoading = false;
        }
    }
    Pane {
        anchors.fill: parent
        Column {
            anchors.fill: parent
            spacing: 5

            RowLayout {
                width: parent.width
                InterimIcon {
                    Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                    Layout.margins: 4
                    source: "qrc:/icons/event_upcoming.svg"
                    ToolTip.text: qsTr("Start date", "Unavailability")
                    ToolTip.visible: hovered
                }
                DateEdit {
                    id: startDateEdit
                    Layout.fillWidth: true
                    text: unavailability
                          ? unavailability.startDate.toLocaleDateString(Qt.locale(), Locale.ShortFormat)
                          : ""
                    placeholderText: dateFormat
                    // inputMask: dateFormat.replace(/[./-]/g, "[$&]").replace(/(dd|d|MM|M)/g, "00").replace(/(yy)/g, "00")
                    isClearButtonVisible: true

                    onTextEdited: {
                        var newDate = Date.fromLocaleString(Qt.locale(), startDateEdit.text, dateFormat);
                        if (!isNaN(newDate)) {
                            startDateEdit.selectedDate = newDate;
                        }
                    }

                    onSelectedDateChanged: {
                        if (unavailability) {
                            var modelIndex = unavailabilityModel.getUnavailabilityIndex(unavailability.unavailabilityId);
                            unavailabilityModel.setData(modelIndex, selectedDate, UnavailabilityModel.StartDateRole);
                        }
                        isDateLoading = true;
                        isDateLoading = false;
                    }

                    onClearTriggered: {
                        var modelIndex = unavailabilityModel.getUnavailabilityIndex(unavailability.unavailabilityId);
                        unavailabilityModel.setData(modelIndex, undefined, UnavailabilityModel.StartDateRole);
                        isDateLoading = true;
                        isDateLoading = false;
                    }
                }
            }
            RowLayout {
                width: parent.width
                InterimIcon {
                    Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                    Layout.margins: 4
                    source: "qrc:/icons/event_available.svg"
                    ToolTip.text: qsTr("End date", "Unavailability")
                    ToolTip.visible: hovered
                }
                DateEdit {
                    id: endDateEdit
                    Layout.fillWidth: true
                    text: unavailability
                          ? unavailability.endDate.toLocaleDateString(Qt.locale(), Locale.ShortFormat)
                          : ""
                    placeholderText: dateFormat
                    // inputMask: dateFormat.replace(/[./-]/g, "[$&]").replace(/(dd|d|MM|M)/g, "00").replace(/(yy)/g, "00")
                    isClearButtonVisible: true
                    validator: isDateLoading ? null : endDateValidator

                    onTextEdited: {
                        var newDate = Date.fromLocaleString(Qt.locale(), endDateEdit.text, dateFormat);
                        if (!isNaN(newDate)) {
                            endDateEdit.selectedDate = newDate;
                        }
                    }

                    onSelectedDateChanged: {
                        if (unavailability) {
                            var modelIndex = unavailabilityModel.getUnavailabilityIndex(unavailability.unavailabilityId);
                            unavailabilityModel.setData(modelIndex, selectedDate, UnavailabilityModel.EndDateRole);
                        }
                        isDateLoading = true;
                        isDateLoading = false;
                    }

                    onClearTriggered: {
                        var modelIndex = unavailabilityModel.getUnavailabilityIndex(unavailability.unavailabilityId);
                        unavailabilityModel.setData(modelIndex, undefined, UnavailabilityModel.EndDateRole);
                        isDateLoading = true;
                        isDateLoading = false;
                    }
                }
            }
            Label {
                id: endDateErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
        }
    }
}
