import QtCore
import QtQuick
import QtQuick.Window
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase 1.0
import "controls"

ItemDelegate {
    id: unavailabilityItemDelegate

    // PROPERTY DECLARATIONS

    // OBJECT PROPERTIES
    width: LookupControl.view.width
    height: delegateContent.implicitHeight + topPadding + bottomPadding
    highlighted: LookupControl.view.currentIndex === index
    hoverEnabled: LookupControl.view.hoverEnabled

    // CHILD OBJECTS
    contentItem: Item {
        Column {
            id: delegateContent

            width: parent.width

            HoverHandler {
                id: hoverHandler
                acceptedDevices: PointerDevice.AllDevices
                //cursorShape: Qt.PointingHandCursor
                enabled: !unavailabilityItemDelegate.LookupControl.view.isEditing
            }

            Item {
                height: childrenRect.height
                width: parent.width

                RowLayout {
                    Layout.leftMargin: 50
                    Layout.rightMargin: 50
                    width: parent.width
                    spacing: 6
                    // height: childrenRect.height
                    // anchors.verticalCenter: parent.verticalCenter

                    ValidationTextField {
                        id: startDateText
                        Layout.fillWidth: true
                        Layout.alignment: Qt.AlignTop
                        Layout.margins: 0
                        width: parent.width
                        horizontalAlignment: Text.AlignRight
                        verticalAlignment: Text.AlignVCenter

                        text: startDate.toLocaleDateString(Qt.locale(), Locale.ShortFormat)
                        wrapMode: TextInput.WordWrap
                        readOnly: true
                        background.visible: false
                        activeFocusOnPress: false
                        selectByMouse: false

                        TapHandler {
                            acceptedDevices: PointerDevice.AllDevices
                            onTapped: unavailabilityItemDelegate.LookupControl.view.currentIndex = index
                        }
                    }
                    Label {
                        text: " - "
                    }
                    ValidationTextField {
                        id: endDateText
                        Layout.fillWidth: true
                        Layout.alignment: Qt.AlignTop
                        Layout.margins: 0
                        width: parent.width
                        horizontalAlignment: Text.AlignLeft
                        verticalAlignment: Text.AlignVCenter

                        text: endDate.toLocaleDateString(Qt.locale(), Locale.ShortFormat)
                        wrapMode: TextInput.WordWrap
                        readOnly: true
                        background.visible: false
                        activeFocusOnPress: false
                        selectByMouse: false

                        TapHandler {
                            acceptedDevices: PointerDevice.AllDevices
                            onTapped: unavailabilityItemDelegate.LookupControl.view.currentIndex = index
                        }
                    }
                }
                Row {
                    id: buttonRow
                    //height: childrenRect.height
                    // anchors.verticalCenter: parent.verticalCenter
                    anchors.right: parent.right

                    ToolButton {
                        id: buttonDelete
                        icon.source: "qrc:/icons/delete.svg"
                        z: 2
                        visible: canEditAvailabilities && hoverHandler.hovered
                        onClicked: unavailabilityModel.removeUnavailability(unavailabilityId)
                    }
                    ToolButton {
                        id: buttonEdit
                        icon.source: hoverHandler.hovered ? "qrc:/icons/edit.svg" : "qrc:/icons/more.svg"
                        z: 2
                        visible: canEditAvailabilities //&& hoverHandler.hovered
                        onClicked: {
                            unavailabilityEditStack.push(unavailabilityDetailPage, { unavailability: unavailability });
                        }
                    }
                }
            }
        }
    }

    background: Rectangle {
        width: unavailabilityItemDelegate.LookupControl.view.width
        color: unavailabilityItemDelegate.down || unavailabilityItemDelegate.hovered
               ? Qt.tint(index % 2 == 0
                         ? myPalette.base
                         : myPalette.alternateBase,
                         Qt.rgba(myPalette.highlight.r,
                                 myPalette.highlight.g,
                                 myPalette.highlight.b,
                                 unavailabilityItemDelegate.down ? 1.0 : 0.2))
               : index % 2 == 0
                 ? myPalette.base
                 : myPalette.alternateBase
    }
}
