import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase 1.0
import "controls"

Item {
    property alias unavailabilityEditStack: _unavailabilityEditStack
    property alias unavailabilityListView: _unavailabilityListView
    property alias unavailabilityCalendarListview: _unavailabilityCalendarListview

    RowLayout {
        anchors.fill: parent
        Layout.fillHeight: true
        Layout.fillWidth: true
        spacing: 10

        StackView {
            id: _unavailabilityEditStack

            width: 400
            Layout.fillHeight: true
            implicitWidth: 400
            implicitHeight: parent.height
            clip: true

            initialItem: LookupControl {
                id: _unavailabilityListView

                showSearchField: false
                showFilterControls: false
                showGroupControls: false
                // groupByIndex: 0
                showEditButton: false
                isEditing: false
                showAddButton: canEditAvailabilities

                //layoutDirection: Qt.LeftToRight

                clip: true
                // boundsBehavior: Flickable.StopAtBounds

                // groupByModel: ListModel {
                //     ListElement {
                //         key: qsTr("Year", "Unavailability")
                //         value: "year"
                //     }
                // }

                delegate: UnavailabilityItemDelegate {}

                section.property: "year"
                section.criteria: ViewSection.FullString
                section.delegate: Pane {
                    id: unavailabilitySection
                    width: ListView.view.width
                    background: Rectangle {
                        anchors.fill: parent
                        color: TBStyle.primaryColor
                    }
                    Label {
                        width: parent.width
                        anchors.centerIn: parent
                        text: section
                        horizontalAlignment: Qt.AlignHCenter
                        verticalAlignment: Qt.AlignVCenter
                        font: TBStyle.bodyMediumFont
                        color: TBStyle.onPrimaryColor
                    }
                }

                ScrollBar.vertical: ScrollBar {
                    active: true
                }
            }
        }

        GridView {
            id: _unavailabilityCalendarListview

            Layout.fillHeight: true
            Layout.fillWidth: true

            //snapMode: ListView.SnapOneItem
            clip: true
            boundsBehavior: Flickable.StopAtBounds
            cellWidth: 330
            cellHeight: 250 // cellWidth

            delegate: calendarListViewItemDelegate

            ScrollIndicator.horizontal: ScrollIndicator {}

            ScrollBar.vertical: ScrollBar {
                active: true
            }
        }
    }
}
