import QtCore
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase 1.0
import "controls"

UnavailabilityEditorForm {
    id: unavailabilityForm

    // PROPERTY DECLARATIONS

    // SIGNAL DECLARATIONS

    // JAVASCRIPT FUNCTIONS
    function loadUnavailabilities(personId) {
        unavailabilityModel.loadUnavailabilities(personId);
    }

    // OBJECT PROPERTIES
    unavailabilityListView.model: unavailabilityProxyModel
    unavailabilityCalendarListview.model: calendarModel

    unavailabilityListView.onAddItem: {
        var unavailabilityIndex = unavailabilityModel.addUnavailability(currentPerson.id);
        var unavailabilityProxyIndex = unavailabilityProxyModel.mapFromSource(unavailabilityIndex);
        unavailabilityListView.currentIndex = unavailabilityProxyIndex.row;
        var newUnavailability = unavailabilityModel.data(unavailabilityIndex, UnavailabilityModel.UnavailabilityRole);
        unavailabilityEditStack.push(unavailabilityDetailPage, { unavailability: newUnavailability });
    }

    // CHILD OBJECTS
    SystemPalette { id: myPalette; colorGroup: SystemPalette.Active }

    UnavailabilityModel {
        id: unavailabilityModel
        onModelChanged: {
            unavailabilityCalendarListview.model = 0;
            unavailabilityCalendarListview.model = calendarModel;
        }
    }

    UnavailabilitySFProxyModel {
        id: unavailabilityProxyModel
        source: unavailabilityModel
    }

    CalendarModel {
        id: calendarModel
        from: new Date(new Date().getFullYear(), 0, 1)
        to: new Date(new Date().getFullYear() + 1, 11, 31)
    }

    Component {
        id: calendarListViewItemDelegate

        GridLayout {
            rows: 3
            columns: 2

            Label {
                id: monthYearTitle
                Layout.row: 0
                Layout.columnSpan: 2
                Layout.fillHeight: true
                Layout.fillWidth: true
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                font.pixelSize: personsForm.font.pixelSize * 1.2
                text: Qt.locale().monthName(model.month) + " " + model.year;
            }

            DayOfWeekRow {
                locale: monthGrid.locale
                Layout.row: 1
                Layout.column: 1
                Layout.columnSpan: 2
                Layout.fillWidth: true

                spacing: 8
                delegate: Label {
                    text: shortName
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter

                    required property string shortName
                }
            }
            WeekNumberColumn {
                Layout.fillHeight: true
                Layout.column: 0
                Layout.row: 2
                month: monthGrid.month
                year: monthGrid.year
                locale: monthGrid.locale

                spacing: 8
                delegate: Label {
                    text: weekNumber
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter

                    required property int weekNumber
                }
            }
            MonthGrid {
                id: monthGrid
                Layout.fillWidth: true
                Layout.fillHeight: true
                Layout.row: 2
                Layout.column: 1
                month: model.month
                year: model.year
                locale: Qt.locale()
                delegate: InfoBox {
                    topInset: 0
                    bottomInset: 0
                    leftInset: 0
                    rightInset: 0
                    opacity: model.month === monthGrid.month ? 1 : 0.5
                    text: model.day
                    backgroundColor: unavailabilityModel.isUnavailable(model.date) ? TBStyle.alertColor : "transparent"
                    textColor: unavailabilityModel.isUnavailable(model.date) ? myPalette.window : myPalette.windowText
                }
            }
        }
    }

    Component {
        id: unavailabilityDetailPage

        UnavailabilityPage {
            Layout.fillWidth: true
            Layout.fillHeight: true

            onPageCanceled: {
                // drop changes and reload unavailabilities
                unavailabilityModel.loadUnavailabilities(currentPerson.id)
            }
        }
    }

    Component {
        id: unavailabilityListViewItemDelegate

        ItemDelegate {
            id: delegate
            width: unavailabilityListView.width - unavailabilityListView.leftMargin - unavailabilityListView.rightMargin

            Layout.alignment: Qt.AlignHCenter | Qt.AlignVCenter

            checkable: true
            contentItem: UnavailabilityItemDelegate {}
        }
    }
    // STATES

    // TRANSITIONS
}

