import QtCore
import QtQuick
import QtQuick.Window
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase 1.0
import "controls"
import "sidePanelScripts.js" as SPScripts

ItemDelegate {
    id: territoryStreetDelegate

    // property declarations
    property bool isValidationTextVisible: false
    property bool isStreetNameLoading: true
    property bool isStreetTypeLoading: true
    property bool isHouseNumberLoading: true

    // signal declarations

    // object properties
    leftPadding: !mirrored ? 0 : undefined
    rightPadding: !mirrored ? undefined : 0
    width: LookupControl.view.width
    height: delegateContent.implicitHeight + topPadding + bottomPadding
    highlighted: LookupControl.view.currentIndex === index
    hoverEnabled: LookupControl.view.hoverEnabled

    // child objects
    TerritoryStreetValidator {
        id: streetNameValidator
        model: territoryStreetDelegate.LookupControl.view.model.source
        streetId: streetId
        role: TerritoryStreetModel.StreetNameRole
        onErrorChanged: function(error) { streetNameErrorLabel.text = error }
        onStreetIdChanged: {
            isValidationTextVisible = false;
            isStreetNameLoading = true;
            isStreetNameLoading = false;
        }
    }
    TerritoryStreetValidator {
        id: streetTypeValidator
        model: territoryStreetDelegate.LookupControl.view.model.source
        streetId: streetId
        role: TerritoryStreetModel.StreetTypeIdRole
        onErrorChanged: function(error) { streetTypeErrorLabel.text = error }
        onStreetIdChanged: {
            isValidationTextVisible = false;
            isStreetTypeLoading = true;
            isStreetTypeLoading = false;
        }
    }
    TerritoryStreetValidator {
        id: fromNumberValidator
        model: territoryStreetDelegate.LookupControl.view.model.source
        streetId: streetId
        role: TerritoryStreetModel.FromNumberRole
        onErrorChanged: function(error) { fromNumberErrorLabel.text = error }
        onStreetIdChanged: {
            isValidationTextVisible = false;
            isHouseNumberLoading = true;
            isHouseNumberLoading = false;
        }
    }
    TerritoryStreetValidator {
        id: toNumberValidator
        model: territoryStreetDelegate.LookupControl.view.model.source
        streetId: streetId
        role: TerritoryStreetModel.ToNumberRole
        onErrorChanged: function(error) { toNumberErrorLabel.text = error }
        onStreetIdChanged: {
            isValidationTextVisible = false;
            isHouseNumberLoading = true;
            isHouseNumberLoading = false;
        }
    }

//    Connections {
//        target: territoryStreetDelegate.LookupControl.view.model
//        function onSortChanged() {
//            isValidationTextVisible = false;
//        }
//        function onGroupByChanged() {
//            isValidationTextVisible = false;
//        }
//        function onFilterTextChanged() {
//            isValidationTextVisible = false;
//        }
//    }
    Connections {
        target: territoryStreetDelegate.LookupControl.view.model.source
        function onModelChanged() {
            isValidationTextVisible = false;
        }
    }

    contentItem: Row {
        id: delegateContent
        spacing: 5

        Rectangle {
            width: 5
            height: parent.height
            color: streetTypeColor
        }
        Column {
            width: parent.width

            HoverHandler {
                id: hoverHandler
                acceptedDevices: PointerDevice.AllDevices
                //cursorShape: Qt.PointingHandCursor
                enabled: !territoryStreetDelegate.LookupControl.view.isEditing
            }

            Column {
                id: delegateContentLayout1
                width: parent.width

                RowLayout {
                    width: parent.width
                    spacing: 6
                    ValidationTextField {
                        id: streetNameTextField
                        Layout.fillWidth: true
                        Layout.alignment: Qt.AlignTop
                        Layout.margins: 0
                        horizontalAlignment: Text.AlignLeft
                        verticalAlignment: Text.AlignVCenter

                        text: streetName
                        wrapMode: TextInput.WordWrap
                        validator: isStreetNameLoading ? null : streetNameValidator
                        readOnly: true
                        font: TBStyle.bodyLargeFont
                        background.visible: false
                        activeFocusOnPress: false
                        selectByMouse: false

                        TapHandler {
                            acceptedDevices: PointerDevice.AllDevices
                            onTapped: territoryStreetDelegate.LookupControl.view.currentIndex = index
                        }

                        onTextEdited: {
                            var modelIndex = streetModel.getStreetIndex(streetId);
                            streetModel.setData(modelIndex, text, TerritoryStreetModel.StreetNameRole);
                            streetModel.saveStreets();
                            // trigger revalidation by switching isLoaded value
                            isStreetNameLoading = true;
                            isStreetNameLoading = false;
                        }
                    }
                    ValidationTextField {
                        id: fromNumberTextField
                        Layout.alignment: Qt.AlignTop | Qt.AlignRight
                        Layout.margins: 0
                        horizontalAlignment: Text.AlignRight
                        verticalAlignment: Text.AlignVCenter

                        text: fromNumber
                        wrapMode: TextInput.WordWrap
                        validator: isHouseNumberLoading ? null : fromNumberValidator
                        readOnly: true
                        font: TBStyle.bodyLargeFont
                        background.visible: false
                        activeFocusOnPress: false
                        selectByMouse: false

                        TapHandler {
                            acceptedDevices: PointerDevice.AllDevices
                            onTapped: territoryStreetDelegate.LookupControl.view.currentIndex = index
                        }

                        onTextEdited: {
                            var modelIndex = streetModel.getStreetIndex(streetId);
                            streetModel.setData(modelIndex, text, TerritoryStreetModel.FromNumberRole);
                            streetModel.saveStreets();
                            // trigger revalidation by switching isLoaded value
                            isHouseNumberLoading = true;
                            isHouseNumberLoading = false;
                        }
                    }
                    Label { text: " - "; visible: fromNumber !== "" && toNumber !== "" }
                    ValidationTextField {
                        id: toNumberTextField
                        Layout.alignment: Qt.AlignTop | Qt.AlignRight
                        Layout.margins: 0
                        horizontalAlignment: Text.AlignLeft
                        verticalAlignment: Text.AlignVCenter

                        text: toNumber
                        wrapMode: TextInput.WordWrap
                        validator: isHouseNumberLoading ? null : toNumberValidator
                        readOnly: true
                        font: TBStyle.bodyLargeFont
                        background.visible: false
                        activeFocusOnPress: false
                        selectByMouse: false

                        TapHandler {
                            acceptedDevices: PointerDevice.AllDevices
                            onTapped: territoryStreetDelegate.LookupControl.view.currentIndex = index
                        }

                        onTextEdited: {
                            var modelIndex = streetModel.getStreetIndex(streetId);
                            streetModel.setData(modelIndex, text, TerritoryStreetModel.ToNumberRole);
                            streetModel.saveStreets();
                            // trigger revalidation by switching isLoaded value
                            isHouseNumberLoading = true;
                            isHouseNumberLoading = false;
                        }
                    }
                    Item {
                        id: editButtonRow
                        implicitWidth: Math.max(buttonEdit.implicitBackgroundWidth + buttonEdit.leftInset + buttonEdit.rightInset,
                                                buttonEdit.implicitContentWidth + buttonEdit.leftPadding + buttonEdit.rightPadding) * 3
                        Layout.alignment: Qt.AlignVCenter | Qt.AlignRight
                        Layout.margins: 0
                        Layout.leftMargin: 5
                        Layout.rightMargin: 10
                        Layout.fillHeight: true

                        RowLayout {
                            anchors.right: parent.right
                            anchors.verticalCenter: parent.verticalCenter
                            ToolButton {
                                id: buttonZoom
                                Layout.fillWidth: true
                                Layout.alignment: Qt.AlignVCenter
                                padding: 0
                                spacing: 0
                                topInset: 0
                                bottomInset: 0
                                z: 2
                                icon.source: "qrc:/icons/fullscreen.svg"
                                visible: hoverHandler.hovered

                                onClicked: {
                                    territoryStreetDelegate.LookupControl.view.currentIndex = index;
                                    if (currentStreet?.streetId !== streetId) {
                                        currentStreet = streetModel.findStreet(streetId);
                                    }
                                    territoryManager.zoomSelectedStreet();
                                }
                            }
                            ToolButton {
                                id: buttonDelete
                                Layout.fillWidth: true
                                Layout.alignment: Qt.AlignVCenter
                                padding: 0
                                spacing: 0
                                topInset: 0
                                bottomInset: 0
                                z: 2
                                icon.source: "qrc:/icons/delete.svg"
                                visible: canEditTerritories && hoverHandler.hovered

                                onClicked: {
                                    streetModel.removeStreet(streetId);
                                }
                            }
                            ToolButton {
                                id: buttonEdit
                                Layout.fillWidth: true
                                Layout.alignment: Qt.AlignVCenter
                                padding: 0
                                spacing: 0
                                topInset: 0
                                bottomInset: 0
                                icon.source: "qrc:/icons/edit.svg"
                                z: 2
                                visible: canEditTerritories && hoverHandler.hovered

                                onClicked: {
                                    streetsEditStack.push(streetDetailPage, { street: street });
                                }
                            }
                        }
                    }
                }
                RowLayout {
                    width: parent.width
                    ValidationTextField {
                        id: streetTypeTextField
                        Layout.fillWidth: true
                        Layout.alignment: Qt.AlignVCenter | Qt.AlignLeft
                        Layout.margins: 0
                        horizontalAlignment: Text.AlignLeft
                        verticalAlignment: Text.AlignVCenter

                        text: streetTypeName
                        wrapMode: TextInput.WordWrap
                        validator: isStreetTypeLoading ? null : streetTypeValidator
                        readOnly: true
                        font: TBStyle.bodyLargeFont
                        background.visible: false
                        activeFocusOnPress: false
                        selectByMouse: false

                        TapHandler {
                            acceptedDevices: PointerDevice.AllDevices
                            onTapped: territoryStreetDelegate.LookupControl.view.currentIndex = index
                        }
                    }
                    InfoBox {
                        id: quantityInfoBox
                        Layout.alignment: Qt.AlignTop | Qt.AlignRight
                        Layout.margins: 0

                        backgroundColor: TBStyle.primaryTextColor
                        textColor: myPalette.window
                        text: quantity
                        visible: quantity > 0
                    }
                }
            }

            // error labels
            Label {
                id: streetNameErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
            Label {
                id: streetTypeErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
            Label {
                id: fromNumberErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
            Label {
                id: toNumberErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
            Label {
                id: nameErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
        }
    }

    background: Rectangle {
        width: territoryStreetDelegate.LookupControl.view.width
        color: index === territoryStreetDelegate.LookupControl.view.currentIndex
               ? myPalette.highlight
               : territoryStreetDelegate.down || territoryStreetDelegate.hovered
                 ? Qt.tint(index % 2 == 0
                           ? myPalette.base
                           : myPalette.alternateBase,
                           Qt.rgba(myPalette.highlight.r,
                                   myPalette.highlight.g,
                                   myPalette.highlight.b,
                                   territoryStreetDelegate.down ? 1.0 : 0.2))
                 : index % 2 == 0
                   ? myPalette.base
                   : myPalette.alternateBase
    }

    onClicked: territoryStreetDelegate.LookupControl.view.currentIndex = index
}
