import QtQuick
import QtLocation
import QtPositioning

MapItemView {
    id: mapItemView

    required property int territoryId
    required property var multiPolygon

    property bool isSelected: false

    delegate: MapPolygon {
        id: myMapPolygon

        border.color: isSelected ? "#ff0000" : "#ff00ff"
        border.width: 2
        opacity: 0.25
        smooth: true

        geoShape: modelData

        states: [
            State {
                name: "IsSelected"; when: isSelected && boundaryLayer.boundaryDisplayOption >= 1
                PropertyChanges { target: myMapPolygon; opacity: 0.75; border.width: 4; visible: true }
            },
            State {
                name: "IsNotSelected"; when: !isSelected && boundaryLayer.boundaryDisplayOption === 2
                PropertyChanges { target: myMapPolygon; opacity: 0.5; border.width: 3; visible: true }
            },
            State {
                name: "Hidden"; when: boundaryLayer.boundaryDisplayOption === 0 || (boundaryLayer.boundaryDisplayOption === 1 && !isSelected)
                PropertyChanges { target: myMapPolygon; opacity: 0; border.width: 10; visible: false }
            }
        ]

        PointHandler {
            id: pointHandler
            acceptedButtons: Qt.LeftButton | Qt.RightButton
            target: null

            onPointChanged: {
                if (vectorLayer.isDigitizing) {
                    return;
                }

                if (point.pressedButtons === Qt.RightButton) {
                    contextMenu.show(null, territoryId, -1);
                    return;
                }
            }
        }

        TapHandler {
            id: tapHandler
            //gesturePolicy: TapHandler.ReleaseWithinBounds
            onTapped: {
                if (vectorLayer.isDigitizing)
                    return;
                territoryManager.currentTerritory = territoryTreeModel.findTerritory(territoryId);
            }
        }
    }

    Connections {
        target: territoryManager
        function onCurrentTerritoryChanged() {
            if (territoryManager.currentTerritory) {
                isSelected = territoryManager.currentTerritory.territoryId === territoryId ? true : false;
            } else {
                isSelected = false;
            }
        }
    }

    Component.onCompleted: {
        if (territoryManager.currentTerritory) {
            isSelected = territoryManager.currentTerritory.territoryId === territoryId ? true : false;
        } else {
            isSelected = false;
        }
    }
}
