
/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2023, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick
import QtQuick.Window
import QtQuick.Controls
import QtQml.Models
import QtQuick.Dialogs
import QtQuick.Layouts
import QtPositioning
import QtLocation
import net.theocbase 1.0
import "controls"

Pane {
    id: root

    // property alias territoryMap: _territoryMap
    property alias territoryTreeView: territoryTreeView
    property alias sidebar: sidebar
    property alias showSidePanelButton: showSidePanelButton
    property alias busyIndicator: _busyIndicator
    property alias mapView: territoryMapLoader.item

    LayoutMirroring.enabled: Qt.application.layoutDirection === Qt.RightToLeft
    LayoutMirroring.childrenInherit: true

    SystemPalette {
        id: myPalette
        colorGroup: SystemPalette.Active
    }

    SplitView {
        id: splitView

        anchors.fill: parent
        orientation: Qt.Horizontal

        Pane {
            SplitView.minimumWidth: root.width * 0.5
            SplitView.fillWidth: true

            padding: 0
            spacing: 0

            SplitView {
                anchors.fill: parent
                Layout.fillWidth: true
                Layout.fillHeight: true
                orientation: Qt.Horizontal
                clip: true

                ColumnLayout {
                    SplitView.preferredWidth: 300

                    // Layout.margins: 5
                    // Layout.fillHeight: true
                    // Layout.fillWidth: true
                    LookupTreeView {
                        id: territoryTreeView

                        // TODO: Support RTL layout
                        LayoutMirroring.enabled: false
                        LayoutMirroring.childrenInherit: true

                        property var columnWidths: [150, width - 150, 0, 0, 0]

                        Layout.fillWidth: true
                        Layout.fillHeight: true
                        Layout.rightMargin: 10

                        width: parent.width
                        clip: true
                        focus: true
                        alternatingRows: true

                        //keyNavigationEnabled: true
                        showFilterControls: false
                        showGroupControls: true
                        groupByIndex: -1
                        showAddButton: true
                        showEditButton: false
                        isEditing: false

                        model: territoriesProxyModel

                        // model: TableModel {
                        //     TableModelColumn {
                        //         display: "name"
                        //     }
                        //     TableModelColumn {
                        //         display: "color"
                        //     }

                        //     rows: [{
                        //             "name": "catz",
                        //             "color": "black"
                        //         }, {
                        //             "name": "dog",
                        //             "color": "brown"
                        //         }, {
                        //             "name": "bird",
                        //             "color": "white"
                        //         }]
                        // }
                        // delegate: Rectangle {
                        //     implicitWidth: 100
                        //     implicitHeight: 20
                        //     color: palette.base
                        //     Label {
                        //         text: display
                        //     }
                        // }
                        selectionModel: ItemSelectionModel {}

                        groupByModel: ListModel {
                            ListElement {
                                key: qsTr("City", "Group territories by city")
                                value: "city"
                            }
                            ListElement {
                                key: qsTr("Publisher",
                                          "Group territories by publisher")
                                value: "publisher"
                            }
                            ListElement {
                                key: qsTr("Type",
                                          "Group territories by type of the territory")
                                value: "type_id"
                            }
                            ListElement {
                                key: qsTr("Worked through",
                                          "Group territories by time frame they have been worked through")
                                value: "workedthrough"
                            }
                        }

                        delegate: territoriesItemDelegate
                        headerDelegate: territoriesHeaderDelegate
                    }
                }

                Item {
                    // Layout.margins: 5
                    // Layout.fillHeight: true
                    // Layout.fillWidth: true

                    // TerritoryMap {
                    //     id: _territoryMap

                    //     Layout.fillHeight: true
                    //     Layout.fillWidth: true
                    // }

                    // BusyIndicator {
                    //     id: busyIndicator
                    //     //anchors.centerIn: parent
                    //     running: _territoryMap.isLoadingBoundaries || _territoryMap.isLoadingStreets
                    //     //running: territoryMapFormLoader.status === Loader.Loading
                    // }
                    Loader {
                        id: territoryMapLoader

                        anchors.fill: parent
                        anchors.leftMargin: 5
                        // Layout.fillHeight: true
                        // Layout.fillWidth: true
                        source: "TerritoryMap.qml"
                        active: true
                        asynchronous: true
                        visible: status == Loader.Ready
                    }
                    BusyIndicator {
                        id: _busyIndicator
                        anchors.centerIn: parent
                        //Layout.alignment: Layout.Center
                        running: territoryMapLoader.status === Loader.Loading
                    }

                    ColumnLayout {
                        anchors.right: parent.right
                        anchors.bottom: parent.bottom
                        anchors.rightMargin: 10
                        anchors.bottomMargin: 10

                        // Sidebar open/close button
                        RoundButton {
                            id: showSidePanelButton
                            Layout.alignment: Qt.AlignRight + Qt.AlignBottom
                            icon.source: sidebar.isVisible ? "qrc:/icons/view_sidebar_off.svg" : "qrc:/icons/view_sidebar.svg"
                            icon.color: TBStyle.primaryTextColor
                        }
                    }
                }
            }
        }

        Pane {
            implicitWidth: (root.width * 0.3) < 400 ? 400 : (root.width * 0.3)
            SplitView.minimumWidth: (root.width * 0.3) < 400 ? 400 : (root.width * 0.3)
            SplitView.maximumWidth: root.width * 0.5

            padding: 0
            spacing: 0

            visible: sidebar.isVisible

            Sidebar {
                id: sidebar
                anchors.fill: parent

                hintText: qsTr("Select a territory on the left")
            }
        }
    }
}
