import QtCore
import QtQuick
import QtQuick.Window
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase 1.0
import "controls"
import "sidePanelScripts.js" as SPScripts

ItemDelegate {
    id: territoryAssignmentDelegate

    // property declarations
    property PersonsModel publisherListModel: assignmentModel.getPublisherList()
    property bool isPublisherLoading: true
    property bool isDateLoading: true

    // object properties
    width: LookupControl.view.width
    height: delegateContent.implicitHeight + topPadding + bottomPadding
    highlighted: LookupControl.view.currentIndex === index
    hoverEnabled: LookupControl.view.hoverEnabled

    // child objects
    TerritoryAssignmentValidator {
        id: publisherValidator
        model: territoryAssignmentDelegate.LookupControl.view.model.source
        assignmentId: id
        role: TerritoryAssignmentModel.PersonFullNameRole
        onErrorChanged: function(error) { publisherErrorLabel.text = error }
        onAssignmentIdChanged: {
            isPublisherLoading = true;
            isPublisherLoading = false;
        }
    }
    TerritoryAssignmentValidator {
        id: assignedDateValidator
        model: territoryAssignmentDelegate.LookupControl.view.model.source
        assignmentId: id
        role: TerritoryAssignmentModel.AssignedDateRole
        onErrorChanged: function(error) { assignedDateErrorLabel.text = error }
        onAssignmentIdChanged: {
            isDateLoading = true;
            isDateLoading = false;
        }
    }
    TerritoryAssignmentValidator {
        id: completedDateValidator
        model: territoryAssignmentDelegate.LookupControl.view.model.source
        assignmentId: id
        role: TerritoryAssignmentModel.CompletedDateRole
        onErrorChanged: function(error) { completedDateErrorLabel.text = error }
        onAssignmentIdChanged: {
            isDateLoading = true;
            isDateLoading = false;
        }
    }

    DataObjectListSFProxyModel {
        id: publisherListProxyModel
        source: publisherListModel
    }

    contentItem: Item {
        Column {
            id: delegateContent

            width: parent.width

            HoverHandler {
                id: hoverHandler
                acceptedDevices: PointerDevice.AllDevices
                //cursorShape: Qt.PointingHandCursor
                enabled: !territoryAssignmentDelegate.LookupControl.view.isEditing
            }

            Item {
                height: childrenRect.height
                width: parent.width

                GridLayout {
                    id: assignmentGrid
                    anchors.left: parent.left
                    anchors.right: buttonRow.left

                    rows: 1
                    columns: 4

                    Row {
                        id: assignedDateRow

                        Layout.row: 0
                        Layout.column: 0

                        ToolButton {
                            id: assignedDateIcon
                            anchors.verticalCenter: parent.verticalCenter
                            icon.source: "qrc:/icons/event_upcoming.svg"
                            background: null
                            ToolTip.text: qsTr("Assigned", "Territory assignment")
                            ToolTip.visible: hovered
                            visible: false
                        }
                        DateEdit {
                            id: assignedDateEdit
                            anchors.verticalCenter: parent.verticalCenter
                            implicitWidth: 100
                            readOnly: true
                            text: assignedDate.toLocaleDateString(Qt.locale(), Locale.ShortFormat)
                            validator: isDateLoading ? null : assignedDateValidator
                            isButtonVisible: false
                            isClearButtonVisible: false
                            background.visible: false

                            onSelectedDateChanged: {
                                var modelIndex = assignmentModel.getAssignmentIndex(id);
                                assignmentModel.setData(modelIndex, selectedDate, TerritoryAssignmentModel.AssignedDateRole);
                                assignmentModel.saveAssignments();
                                isDateLoading = true;
                                isDateLoading = false;
                            }
                            onClearTriggered: {
                                var modelIndex = assignmentModel.getAssignmentIndex(id);
                                assignmentModel.setData(modelIndex, undefined, TerritoryAssignmentModel.AssignedDateRole);
                                assignmentModel.saveAssignments();
                                isDateLoading = true;
                                isDateLoading = false;
                            }

                            MouseArea {
                                id: assignedDateEditMouseArea
                                anchors.fill: parent
                                enabled: true
                            }
                        }
                    }
                    Row {
                        id: completedDateRow

                        Layout.row: 0
                        Layout.column: 1

                        ToolButton {
                            id: completedDateIcon
                            anchors.verticalCenter: parent.verticalCenter
                            icon.source: "qrc:/icons/event_available.svg"
                            background: null
                            ToolTip.text: qsTr("Completed", "Territory assignment")
                            ToolTip.visible: hovered
                            visible: false
                        }

                        DateEdit {
                            id: completedDateEdit
                            anchors.verticalCenter: parent.verticalCenter
                            implicitWidth: 100
                            readOnly: true
                            text: completedDate.toLocaleDateString(Qt.locale(), Locale.ShortFormat)
                            validator: isDateLoading ? null : completedDateValidator
                            isButtonVisible: false
                            isClearButtonVisible: false
                            background.visible: false

                            onSelectedDateChanged: {
                                var modelIndex = assignmentModel.getAssignmentIndex(id);
                                assignmentModel.setData(modelIndex, selectedDate, TerritoryAssignmentModel.CompletedDateRole);
                                assignmentModel.saveAssignments();
                                isDateLoading = true;
                                isDateLoading = false;
                            }

                            onClearTriggered: {
                                var modelIndex = assignmentModel.getAssignmentIndex(id);
                                assignmentModel.setData(modelIndex, undefined, TerritoryAssignmentModel.CompletedDateRole);
                                assignmentModel.saveAssignments();
                                isDateLoading = true;
                                isDateLoading = false;
                            }

                            MouseArea {
                                id: completedDateEditMouseArea
                                anchors.fill: parent
                                enabled: true
                            }
                        }
                    }
                    RowLayout {
                        id: assigneeRow

                        Layout.fillWidth: true
                        Layout.row: 0
                        Layout.column: 2

                        ToolButton {
                            id: assigneeIcon
                            icon.source: "qrc:/icons/person.svg"
                            background: null
                            ToolTip.text: qsTr("Publisher", "Territory assignment")
                            ToolTip.visible: hovered
                            visible: false
                        }
                        ValidationTextField {
                            Layout.fillWidth: true

                            text: personFullName
                            validator: isPublisherLoading ? null : publisherValidator
                            readOnly: true
                            background.visible: false
                            activeFocusOnPress: false
                            selectByMouse: false

                            // TapHandler {
                            //     acceptedDevices: PointerDevice.AllDevices
                            //     onTapped: territoryAddressDelegate.LookupControl.view.currentIndex = index
                            // }
                        }
                    }
                }
                Row {
                    id: buttonRow

                    anchors.right: parent.right
                    spacing: 0
                    padding: 0

                    ToolButton {
                        id: buttonDelete
                        padding: 0
                        spacing: 0
                        topInset: 0
                        bottomInset: 0
                        icon.source: "qrc:/icons/delete.svg"
                        z: 2
                        visible: canEditTerritories && hoverHandler.hovered

                        onClicked: assignmentModel.removeAssignment(id)
                    }
                    ToolButton {
                        id: buttonEdit
                        padding: 0
                        spacing: 0
                        topInset: 0
                        bottomInset: 0
                        icon.source: "qrc:/icons/edit.svg"
                        z: 2
                        visible: canEditTerritories && hoverHandler.hovered

                        onClicked: {
                            assignmentEditStack.push(assignmentDetailPage, { assignment: assignment });
                        }
                    }
                }
            }
            Label {
                id: publisherErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
            Label {
                id: assignedDateErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
            Label {
                id: completedDateErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
        }
    }

    background: Rectangle {
        width: territoryAssignmentDelegate.LookupControl.view.width
        color: territoryAssignmentDelegate.down || territoryAssignmentDelegate.hovered
               ? Qt.tint(index % 2 == 0
                         ? myPalette.base
                         : myPalette.alternateBase,
                         Qt.rgba(myPalette.highlight.r,
                                 myPalette.highlight.g,
                                 myPalette.highlight.b,
                                 territoryAssignmentDelegate.down ? 1.0 : 0.2))
               : index % 2 == 0
                 ? myPalette.base
                 : myPalette.alternateBase
    }
}
