import QtCore
import QtQuick
import QtQuick.Window
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase 1.0
import "controls"
import "sidePanelScripts.js" as SPScripts

ItemDelegate {
    id: territoryAddressDelegate

    // property declarations
    property bool isValidationTextVisible: false
    property bool isStreetNameLoading: true
    property bool isAddressTypeLoading: true
    property bool isHouseNumberLoading: true
    property bool isNameLoading: true

    // signal declarations
    signal deleteTerritoryAddress(int id)
    //signal editTerritoryAddress(int id)

    // object properties
    width: LookupControl.view.width
    height: delegateContent.implicitHeight + topPadding + bottomPadding
    highlighted: LookupControl.view.currentIndex === index
    hoverEnabled: LookupControl.view.hoverEnabled

    // child objects
    TerritoryAddressValidator {
        id: streetNameValidator
        model: territoryAddressDelegate.LookupControl.view.model.source
        addressId: id
        role: TerritoryAddressModel.StreetRole
        onErrorChanged: function(error) { streetNameErrorLabel.text = error }
        onAddressIdChanged: {
            isValidationTextVisible = false;
            isStreetNameLoading = true;
            isStreetNameLoading = false;
        }
    }
    TerritoryAddressValidator {
        id: addressTypeValidator
        model: territoryAddressDelegate.LookupControl.view.model.source
        addressId: id
        role: TerritoryAddressModel.AddressTypeNumberRole
        onErrorChanged: function(error) { addressTypeErrorLabel.text = error }
        onAddressIdChanged: {
            isValidationTextVisible = false;
            isAddressTypeLoading = true;
            isAddressTypeLoading = false;
        }
    }
    TerritoryAddressValidator {
        id: houseNumberValidator
        model: territoryAddressDelegate.LookupControl.view.model.source
        addressId: id
        role: TerritoryAddressModel.HouseNumberRole
        onErrorChanged: function(error) { houseNumberErrorLabel.text = error }
        onAddressIdChanged: {
            isValidationTextVisible = false;
            isHouseNumberLoading = true;
            isHouseNumberLoading = false;
        }
    }
    TerritoryAddressValidator {
        id: nameValidator
        model: territoryAddressDelegate.LookupControl.view.model.source
        addressId: id
        role: TerritoryAddressModel.NameRole
        onErrorChanged: function(error) { nameErrorLabel.text = error }
        onAddressIdChanged: {
            isValidationTextVisible = false;
            isNameLoading = true;
            isNameLoading = false;
        }
    }

//    Connections {
//        target: territoryAddressDelegate.LookupControl.view.model
//        function onSortChanged() {
//            isValidationTextVisible = false;
//        }
//        function onGroupByChanged() {
//            isValidationTextVisible = false;
//        }
//        function onFilterTextChanged() {
//            isValidationTextVisible = false;
//        }
//    }
    Connections {
        target: territoryAddressDelegate.LookupControl.view.model.source
        function onModelChanged() {
            isValidationTextVisible = false;
        }
    }

    contentItem: Column {
        id: delegateContent

        width: parent.width

        HoverHandler {
            id: hoverHandler
            acceptedDevices: PointerDevice.AllDevices
            //cursorShape: Qt.PointingHandCursor
            enabled: !territoryAddressDelegate.LookupControl.view.isEditing
        }

        Column {
            id: delegateContentLayout1
            width: parent.width

            RowLayout {
                width: parent.width
                spacing: 6
                ValidationTextField {
                    id: streetNameTextField
                    Layout.fillWidth: true
                    Layout.alignment: Qt.AlignTop
                    Layout.margins: 0
                    horizontalAlignment: Text.AlignLeft
                    verticalAlignment: Text.AlignVCenter

                    text: street
                    wrapMode: TextInput.WordWrap
                    validator: isStreetNameLoading ? null : streetNameValidator
                    readOnly: true
                    font: TBStyle.bodyLargeFont
                    background.visible: false
                    activeFocusOnPress: false
                    selectByMouse: false

                    TapHandler {
                        acceptedDevices: PointerDevice.AllDevices
                        onTapped: territoryAddressDelegate.LookupControl.view.currentIndex = index
                    }
                }
                ValidationTextField {
                    id: houseNumberTextField
                    Layout.fillWidth: true
                    Layout.alignment: Qt.AlignTop | Qt.AlignRight
                    Layout.margins: 0
                    horizontalAlignment: Text.AlignRight
                    verticalAlignment: Text.AlignVCenter

                    text: houseNumber
                    wrapMode: TextInput.WordWrap
                    validator: isHouseNumberLoading ? null : houseNumberValidator
                    readOnly: true
                    font: TBStyle.bodyLargeFont
                    background.visible: false
                    activeFocusOnPress: false
                    selectByMouse: false

                    TapHandler {
                        acceptedDevices: PointerDevice.AllDevices
                        onTapped: territoryAddressDelegate.LookupControl.view.currentIndex = index
                    }
                }
                Item {
                    id: editButtonRow
                    implicitWidth: Math.max(buttonEdit.implicitBackgroundWidth + buttonEdit.leftInset + buttonEdit.rightInset,
                                            buttonEdit.implicitContentWidth + buttonEdit.leftPadding + buttonEdit.rightPadding) * 3
                    Layout.alignment: Qt.AlignVCenter | Qt.AlignRight
                    Layout.margins: 0
                    Layout.leftMargin: 5
                    Layout.fillHeight: true

                    RowLayout {
                        anchors.right: parent.right
                        anchors.verticalCenter: parent.verticalCenter
                        ToolButton {
                            id: buttonZoom
                            Layout.fillWidth: true
                            Layout.alignment: Qt.AlignVCenter
                            padding: 0
                            spacing: 0
                            topInset: 0
                            bottomInset: 0
                            z: 2
                            icon.source: "qrc:/icons/fullscreen.svg"
                            visible: hoverHandler.hovered

                            onClicked: {
                                territoryManager.zoomCoordinate(latitude, longitude);
                            }
                        }
                        ToolButton {
                            id: buttonDelete
                            Layout.fillWidth: true
                            Layout.alignment: Qt.AlignVCenter
                            padding: 0
                            spacing: 0
                            topInset: 0
                            bottomInset: 0
                            z: 2
                            icon.source: "qrc:/icons/delete.svg"
                            visible: canEditTerritories && hoverHandler.hovered

                            onClicked: {
                                addressModel.removeAddress(id);
                                deleteTerritoryAddress(id);
                            }
                        }
                        ToolButton {
                            id: buttonEdit
                            Layout.fillWidth: true
                            Layout.alignment: Qt.AlignVCenter
                            padding: 0
                            spacing: 0
                            topInset: 0
                            bottomInset: 0
                            icon.source: "qrc:/icons/edit.svg"
                            z: 2
                            visible: canEditTerritories && hoverHandler.hovered

                            onClicked: {
                                addressesEditStack.push(addressDetailPage, { address: address });
                            }
                        }
                    }
                }
            }
            RowLayout {
                width: parent.width
                ValidationTextField {
                    id: nameTextField
                    Layout.fillWidth: true
                    Layout.alignment: Qt.AlignTop | Qt.AlignLeft
                    Layout.margins: 0
                    horizontalAlignment: Text.AlignLeft
                    verticalAlignment: Text.AlignVCenter

                    text: name
                    wrapMode: TextInput.WordWrap
                    validator: isNameLoading ? null : nameValidator
                    readOnly: true
                    background.visible: false
                    activeFocusOnPress: false
                    selectByMouse: false

                    TapHandler {
                        acceptedDevices: PointerDevice.AllDevices
                        onTapped: territoryAddressDelegate.LookupControl.view.currentIndex = index
                    }
                }
                ValidationTextField {
                    id: addressTypeTextField
                    Layout.fillWidth: true
                    Layout.alignment: Qt.AlignVCenter | Qt.AlignLeft
                    Layout.margins: 0
                    horizontalAlignment: Text.AlignLeft
                    verticalAlignment: Text.AlignVCenter

                    text: addressTypeName
                    wrapMode: TextInput.WordWrap
                    validator: isAddressTypeLoading ? null : addressTypeValidator
                    readOnly: true
                    font: TBStyle.bodyLargeFont
                    background.visible: false
                    activeFocusOnPress: false
                    selectByMouse: false

                    TapHandler {
                        acceptedDevices: PointerDevice.AllDevices
                        onTapped: territoryAddressDelegate.LookupControl.view.currentIndex = index
                    }
                }
            }
        }

        // error labels
        Label {
            id: streetNameErrorLabel
            font: TBStyle.bodySmallFont
            color: TBStyle.alertColor
            visible: text
        }
        Label {
            id: addressTypeErrorLabel
            font: TBStyle.bodySmallFont
            color: TBStyle.alertColor
            visible: text
        }
        Label {
            id: houseNumberErrorLabel
            font: TBStyle.bodySmallFont
            color: TBStyle.alertColor
            visible: text
        }
        Label {
            id: nameErrorLabel
            font: TBStyle.bodySmallFont
            color: TBStyle.alertColor
            visible: text
        }
    }

    background: Rectangle {
        width: territoryAddressDelegate.LookupControl.view.width
        color: index === territoryAddressDelegate.LookupControl.view.currentIndex
               ? myPalette.highlight
               : territoryAddressDelegate.down || territoryAddressDelegate.hovered
                 ? Qt.tint(index % 2 == 0
                           ? myPalette.base
                           : myPalette.alternateBase,
                           Qt.rgba(myPalette.highlight.r,
                                   myPalette.highlight.g,
                                   myPalette.highlight.b,
                                   territoryAddressDelegate.down ? 1.0 : 0.2))
                 : index % 2 == 0
                   ? myPalette.base
                   : myPalette.alternateBase
    }

    onClicked: territoryAddressDelegate.LookupControl.view.currentIndex = index
}
