import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import Qt5Compat.GraphicalEffects
import net.theocbase 1.0
import "controls"

Pane {
    id: control

    property alias congregationLayout: _congregationLayout
    property alias personLayout: _personLayout
    property alias congregationStack: _congregationStack
    property alias congregationPage: _congregationPage
    property alias congregationLookupControl: _congregationLookupControl
    // congregation
    property alias congregationNameTextField: _congregationNameTextField
    property alias congregationNameErrorLabel: _congregationNameErrorLabel
    property alias congregationInfoTextArea: _congregationInfoTextArea
    property alias congregationAddressTextArea: _congregationAddressTextArea
    property alias circuitTextField: _circuitTextField
    property alias currentPublicMeetingDayComboBox: _currentPublicMeetingDayComboBox
    property alias currentPublicMeetingTimeTextField: _currentPublicMeetingTimeTextField
    property alias nextPublicMeetingDayComboBox: _nextPublicMeetingDayComboBox
    property alias nextPublicMeetingTimeTextField: _nextPublicMeetingTimeTextField
    // general
    property alias personsCongregationComboBox: _personsCongregationComboBox
    property bool isPersonLoading: true
    property alias firstNameTextField: _firstNameTextField
    property alias firstNameErrorLabel: _firstNameErrorLabel
    property alias lastNameTextField: _lastNameTextField
    property alias lastNameErrorLabel: _lastNameErrorLabel
    property alias phoneTextField: _phoneTextField
    property alias mobileTextField: _mobileTextField
    property alias emailTextField: _emailTextField
    property alias notesTextField: _notesTextField
    property alias isMaleRadioButton: _isMaleRadioButton
    // family
    property alias isFamilyHeadSwitch: _isFamilyHeadSwitch
    property alias familyHeadComboBox: _familyHeadComboBox
    // privileges
    property alias servantCheckBox: _servantCheckBox
    property alias prayerCheckBox: _prayerCheckBox
    // midweek
    property alias midweekChairmanCheckBox: _midweekChairmanCheckBox
    // property alias auxiliaryClassCounselorCheckBox: _auxiliaryClassCounselorCheckBox
    property alias treasuresTalkCheckBox: _treasuresTalkCheckBox
    property alias spiritualGemsCheckBox: _spiritualGemsCheckBox
    property alias bibleReadingCheckBox: _bibleReadingCheckBox
    property alias startingConversationCheckBox: _startingConversationCheckBox
    property alias followingUpCheckBox: _followingUpCheckBox
    property alias makingDisciplesCheckBox: _makingDisciplesCheckBox
    property alias assistantCheckBox: _assistantCheckBox
    property alias explainingBeliefsCheckBox: _explainingBeliefsCheckBox
    property alias studentTalkCheckBox: _studentTalkCheckBox
    property alias fmDiscussionCheckBox: _fmDiscussionCheckBox
    property alias allClassesRadioButton: _allClassesRadioButton
    property alias onlyMainClassRadioButton: _onlyMainClassRadioButton
    property alias onlyAuxClassRadioButton: _onlyAuxClassRadioButton
    property alias christianLivingTalkCheckBox: _christianLivingTalkCheckBox
    property alias cbsConductorCheckBox: _cbsConductorCheckBox
    property alias cbsReaderCheckBox: _cbsReaderCheckBox
    // weekend
    property alias weekendChairmanCheckBox: _weekendChairmanCheckBox
    property alias publicTalkCheckBox: _publicTalkCheckBox
    property alias publicTalksLookupControl: _publicTalksLookupControl
    property alias hostCheckBox: _hostCheckBox
    property alias watchtowerConductorCheckBox: _watchtowerConductorCheckBox
    property alias watchtowerReaderCheckBox: _watchtowerReaderCheckBox
    // assignment history
    property alias isLoadingMidweekPartsCheckBox: _isLoadingMidweekPartsCheckBox
    property alias isLoadingWeekendPartsCheckBox: _isLoadingWeekendPartsCheckBox
    property alias historyLookupControl: _historyLookupControl
    // availability
    property alias isBreakCheckBox: _isBreakCheckBox
    property alias unavailabilityEditor: _unavailabilityEditor

    LayoutMirroring.enabled: Qt.application.layoutDirection === Qt.RightToLeft
    LayoutMirroring.childrenInherit: true

    SplitView {
        id: splitView
        anchors.fill: parent
        orientation: Qt.Horizontal
        clip: true

        ColumnLayout {
            id: personListColumnLayout
            SplitView.minimumWidth: 300
            SplitView.maximumWidth: 600
            Layout.margins: 5

            StackView {
                id: _congregationStack

                Layout.fillWidth: true
                Layout.fillHeight: true
                implicitWidth: parent.width
                implicitHeight: parent.height

                initialItem: Page {
                    id: _congregationPage

                    Layout.fillWidth: true
                    Layout.fillHeight: true

                    contentItem: LookupControl {
                        id: _congregationLookupControl

                        showFilterControls: false
                        showSearchField: congregationDelegateModel.rootIndex.valid
                                         || canViewPublicSpeakers
                        showAddButton: (currentCongregation?.isLocalCongregation ?? false)
                                       ? canEditPublishers
                                       : canEditPublicSpeakers
                        showEditButton: false
                        isEditing: false

                        focus: true

                        model: congregationDelegateModel

                        ScrollBar.vertical: ScrollBar {
                            focus: true
                        }
                    }
                }

                clip: true
            }
        }

        ColumnLayout {
            SplitView.fillWidth: true

            GridLayout {
                id: _congregationLayout

                Layout.margins: 5
                Layout.fillHeight: true
                Layout.fillWidth: true

                columns: 2
                rowSpacing: 10

                visible: !congregationDelegateModel.rootIndex.valid && currentCongregation

                Label {
                    Layout.columnSpan: 2
                    text: qsTr("Congregation details")
                    font: TBStyle.titleMediumFont
                }
                // Congregation name and circuit
                ColumnLayout {
                    Layout.fillWidth: true
                    Layout.columnSpan: 2
                    RowLayout {
                        Layout.fillWidth: true
                        RowLayout {
                            Layout.fillWidth: true
                            InterimIcon {
                                Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                                Layout.margins: 4
                                source: "qrc:/icons/home_congregation.svg"
                                ToolTip.text: qsTr("Congregation name")
                                ToolTip.visible: hovered
                            }
                            ValidationTextField {
                                id: _congregationNameTextField
                                Layout.fillWidth: true
                                horizontalAlignment: Text.AlignLeft
                                text: currentCongregation ? currentCongregation.congregationName : ""
                                placeholderText: qsTr("Congregation name")
                                selectByMouse: true
                                showClearButton: true
                                validator: congregationNameValidator
                                enabled: canEditCongregationSettings
                            }
                        }
                        RowLayout {
                            Layout.fillWidth: true
                            InterimIcon {
                                Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                                Layout.margins: 4
                                source: "qrc:/icons/circuit.svg"
                                ToolTip.text: qsTr("Circuit")
                                ToolTip.visible: hovered
                            }
                            ValidationTextField {
                                id: _circuitTextField
                                Layout.fillWidth: true
                                horizontalAlignment: Text.AlignLeft
                                text: currentCongregation ? currentCongregation.circuit : ""
                                placeholderText: qsTr("Circuit")
                                selectByMouse: true
                                showClearButton: true
                                enabled: canEditCongregationSettings
                            }
                        }
                    }
                    Label {
                        id: _congregationNameErrorLabel
                        Layout.fillWidth: true
                        Layout.column: 1
                        Layout.row: 1
                        verticalAlignment: Text.AlignTop
                        font: TBStyle.bodySmallFont
                        color: TBStyle.alertColor
                        visible: text
                        wrapMode: Text.Wrap
                    }
                    Label {
                        id: circuitErrorLabel
                        Layout.fillWidth: true
                        Layout.column: 1
                        Layout.row: 1
                        verticalAlignment: Text.AlignTop
                        font: TBStyle.bodySmallFont
                        color: TBStyle.alertColor
                        visible: text
                        wrapMode: Text.Wrap
                    }
                }
                // Info
                GridLayout {
                    Layout.fillWidth: true
                    Layout.columnSpan: 2
                    columns: 2
                    rows: 2
                    InterimIcon {
                        Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                        Layout.column: 0
                        Layout.row: 0
                        Layout.margins: 4
                        source: "qrc:/icons/info.svg"
                        ToolTip.text: qsTr("Info")
                        ToolTip.visible: hovered
                    }
                    TextArea {
                        id: _congregationInfoTextArea
                        Layout.fillWidth: true
                        horizontalAlignment: Text.AlignLeft
                        text: currentCongregation ? currentCongregation.info : ""
                        placeholderText: qsTr("Info")
                        selectByMouse: true
                        enabled: canEditCongregationSettings
                    }
                    Label {
                        id: congregationInfoErrorLabel
                        Layout.fillWidth: true
                        Layout.column: 1
                        Layout.row: 1
                        verticalAlignment: Text.AlignTop
                        font: TBStyle.bodySmallFont
                        color: TBStyle.alertColor
                        visible: text
                        wrapMode: Text.Wrap
                    }
                }
                // Address
                GridLayout {
                    Layout.fillWidth: true
                    Layout.columnSpan: 2
                    columns: 2
                    rows: 2
                    InterimIcon {
                        Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                        Layout.column: 0
                        Layout.row: 0
                        Layout.margins: 4
                        source: "qrc:/icons/location.svg"
                        ToolTip.text: qsTr("Address")
                        ToolTip.visible: hovered
                    }
                    TextArea {
                        id: _congregationAddressTextArea
                        Layout.fillWidth: true
                        horizontalAlignment: Text.AlignLeft
                        text: currentCongregation ? currentCongregation.address : ""
                        placeholderText: qsTr("Address")
                        selectByMouse: true
                        enabled: canEditCongregationSettings
                    }
                    Label {
                        id: congregationAddressErrorLabel
                        Layout.fillWidth: true
                        Layout.column: 1
                        Layout.row: 1
                        verticalAlignment: Text.AlignTop
                        font: TBStyle.bodySmallFont
                        color: TBStyle.alertColor
                        visible: text
                        wrapMode: Text.Wrap
                    }
                }
                // Meeting times
                Label {
                    Layout.fillWidth: true
                    Layout.columnSpan: 2
                    horizontalAlignment: Text.AlignLeft
                    text: qsTr("Meeting times")
                    font: TBStyle.titleSmallFont
                }
                ColumnLayout {
                    Layout.fillWidth: true
                    Label {
                        text: qsTr("Current year's meeting time")
                    }
                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                            Layout.margins: 4
                            source: "qrc:/icons/event.svg"
                            ToolTip.text: qsTr("Day")
                            ToolTip.visible: hovered
                        }
                        ComboBox {
                            id: _currentPublicMeetingDayComboBox
                            Layout.fillWidth: true

                            model: weekendDayModel
                            valueRole: "key"
                            textRole: "dayName"
                            enabled: canEditCongregationSettings
                        }
                    }
                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                            Layout.margins: 4
                            source: "qrc:/icons/calendar_clock.svg"
                            ToolTip.text: qsTr("Time")
                            ToolTip.visible: hovered
                        }
                        TextField {
                            id: _currentPublicMeetingTimeTextField
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignLeft
                            inputMask: "00:00"
                            inputMethodHints: Qt.ImhTime
                            text: currentCongregation?.currentPublicMeetingDayAndTime?.meetingTime
                                  ? currentCongregation?.currentPublicMeetingDayAndTime?.meetingTime
                                  : "12:00"
                            validator: RegularExpressionValidator {
                                regularExpression: /^([0-1\s]?[0-9\s]|2[0-3\s]):([0-5\s][0-9\s])$ /
                            }
                            enabled: canEditCongregationSettings
                        }
                    }
                }
                ColumnLayout {
                    Layout.fillWidth: true
                    Label {
                        text: qsTr("Next year's meeting time")
                    }
                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                            Layout.margins: 4
                            source: "qrc:/icons/event.svg"
                            ToolTip.text: qsTr("Day")
                            ToolTip.visible: hovered
                        }
                        ComboBox {
                            id: _nextPublicMeetingDayComboBox
                            Layout.fillWidth: true

                            model: weekendDayModel
                            valueRole: "key"
                            textRole: "dayName"
                            enabled: canEditCongregationSettings
                        }
                    }
                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                            Layout.margins: 4
                            source: "qrc:/icons/calendar_clock.svg"
                            ToolTip.text: qsTr("Time")
                            ToolTip.visible: hovered
                        }
                        TextField {
                            id: _nextPublicMeetingTimeTextField
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignLeft
                            inputMask: "00:00"
                            inputMethodHints: Qt.ImhTime
                            text: currentCongregation?.nextPublicMeetingDayAndTime?.meetingTime
                                  ? currentCongregation?.nextPublicMeetingDayAndTime?.meetingTime
                                  : "12:00"
                            validator: RegularExpressionValidator {
                                regularExpression: /^([0-1\s]?[0-9\s]|2[0-3\s]):([0-5\s][0-9\s])$ /
                            }
                            enabled: canEditCongregationSettings
                        }
                    }
                }
                Label {
                    id: congregationMeetingTimesErrorLabel
                    Layout.fillWidth: true
                    Layout.columnSpan: 2
                    verticalAlignment: Text.AlignTop
                    font: TBStyle.bodySmallFont
                    color: TBStyle.alertColor
                    visible: text
                    wrapMode: Text.Wrap
                }
                // Map
                CongregationMap {
                    id: congregationMap
                    Layout.fillWidth: true
                    Layout.fillHeight: true
                    Layout.columnSpan: 2

                    address: currentCongregation?.address ? currentCongregation?.address : ""
                }
            }

            ColumnLayout {
                id: _personLayout

                Layout.topMargin: 5
                Layout.leftMargin: 10
                Layout.fillHeight: true
                Layout.fillWidth: true

                visible: congregationDelegateModel.rootIndex.valid && currentPerson

                TabBar {
                    id: tabBar
                    Layout.fillWidth: true
                    Layout.alignment: Qt.AlignLeft | Qt.AlignTop

                    currentIndex: 0

                    TabButton {
                        id: generalTabButton
                        text: qsTr("General")
                        width: implicitWidth
                        enabled: canViewPublishers || canViewPublicSpeakers
                    }
                    TabButton {
                        id: midweekTabButton
                        text: qsTr("Midweek Meeting")
                        width: implicitWidth
                        enabled: (currentCongregation?.isLocalCongregation ?? false)
                                 && (canViewPrivileges || canViewStudentData)
                    }
                    TabButton {
                        id: weekendTabButton
                        text: qsTr("Weekend Meeting")
                        width: implicitWidth
                        enabled: canViewPublicSpeakers
                                 || ((currentCongregation?.isLocalCongregation ?? false) && canViewPrivileges)
                    }
                    TabButton {
                        id: availabilityTabButton
                        text: qsTr("Availability")
                        width: implicitWidth
                        enabled: canViewAvailabilities
                    }
                    TabButton {
                        id: historyTabButton
                        text: qsTr("History")
                        width: implicitWidth
                        enabled: canViewStudentData
                    }
                }

                StackLayout {
                    clip: true
                    Layout.fillWidth: true
                    Layout.fillHeight: true
                    Layout.topMargin: 10
                    currentIndex: tabBar.currentIndex

                    ColumnLayout {
                        id: generalTab

                        Layout.fillWidth: true
                        Layout.fillHeight: true
                        implicitWidth: parent.width
                        implicitHeight: parent.height
                        spacing: 10

                        // congregation
                        ColumnLayout {
                            Layout.fillWidth: true
                            visible: publicTalkCheckBox.checked
                            Label {
                                Layout.fillWidth: true
                                horizontalAlignment: Text.AlignLeft
                                text: qsTr("Congregation")
                                font: TBStyle.titleMediumFont
                            }
                            LookupComboBox {
                                id: _personsCongregationComboBox
                                Layout.fillWidth: true
                                enabled: canEditPublishers
                                model: congregationTreeModel

                                textRole: "title"
                                valueRole: "congregationId"
                            }
                        }

                        // personal info
                        Label {
                            text: qsTr("Personal info")
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignLeft
                            font: TBStyle.titleMediumFont
                        }
                        GridLayout {
                            Layout.fillWidth: true

                            columns: 2
                            rowSpacing: 10
                            flow: GridLayout.LeftToRight

                            ColumnLayout {
                                Layout.fillWidth: true
                                Layout.columnSpan: 2
                                RowLayout {
                                    Layout.fillWidth: true
                                    InterimIcon {
                                        Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                                        Layout.margins: 4
                                        source: "qrc:/icons/person.svg"
                                        ToolTip.text: qsTr("Name")
                                        ToolTip.visible: hovered
                                    }
                                    ValidationTextField {
                                        id: _firstNameTextField
                                        Layout.fillWidth: true
                                        Layout.minimumWidth: 100
                                        horizontalAlignment: Text.AlignLeft
                                        text: currentPerson ? currentPerson.firstName : ""
                                        placeholderText: qsTr("First name")
                                        selectByMouse: true
                                        showClearButton: true
                                        validator: isPersonLoading ? null : firstNameValidator
                                        enabled: (currentCongregation?.isLocalCongregation ?? false)
                                                 ? canEditPublishers
                                                 : canEditPublicSpeakers
                                    }
                                    ValidationTextField {
                                        id: _lastNameTextField
                                        Layout.fillWidth: true
                                        horizontalAlignment: Text.AlignLeft
                                        text: currentPerson ? currentPerson.lastName : ""
                                        placeholderText: qsTr("Last name")
                                        selectByMouse: true
                                        showClearButton: true
                                        validator: isPersonLoading ? null : lastNameValidator
                                        enabled: (currentCongregation?.isLocalCongregation ?? false)
                                                 ? canEditPublishers
                                                 : canEditPublicSpeakers
                                    }
                                }
                                Label {
                                    id: _lastNameErrorLabel
                                    Layout.fillWidth: true
                                    verticalAlignment: Text.AlignTop
                                    font: TBStyle.bodySmallFont
                                    color: TBStyle.alertColor
                                    visible: text
                                    wrapMode: Text.Wrap
                                }
                                Label {
                                    id: _firstNameErrorLabel
                                    Layout.fillWidth: true
                                    verticalAlignment: Text.AlignTop
                                    font: TBStyle.bodySmallFont
                                    color: TBStyle.alertColor
                                    visible: text && text !== _lastNameErrorLabel.text
                                    wrapMode: Text.Wrap
                                }
                            }

                            GridLayout {
                                Layout.fillWidth: true
                                columns: 2
                                rows: 2
                                visible: (currentCongregation?.isLocalCongregation ?? false)
                                         ? canViewPublishers || (canViewPublicSpeakers && publicTalkCheckBox.checked)
                                         : canViewPublicSpeakers
                                InterimIcon {
                                    Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                                    Layout.column: 0
                                    Layout.row: 0
                                    Layout.margins: 4
                                    source: "qrc:/icons/call.svg"
                                    ToolTip.text: qsTr("Phone")
                                    ToolTip.visible: hovered
                                }
                                ValidationTextField {
                                    id: _phoneTextField
                                    Layout.fillWidth: true
                                    Layout.minimumWidth: 100
                                    horizontalAlignment: Text.AlignLeft
                                    text: currentPerson ? currentPerson.phone : ""
                                    placeholderText: qsTr("Phone")
                                    selectByMouse: true
                                    showClearButton: true
                                    enabled: (currentCongregation?.isLocalCongregation ?? false)
                                             ? canEditPublishers
                                             : canEditPublicSpeakers
                                }
                            }
                            GridLayout {
                                Layout.fillWidth: true
                                columns: 2
                                rows: 2
                                visible: (currentCongregation?.isLocalCongregation ?? false)
                                         ? canViewPublishers || (canViewPublicSpeakers && publicTalkCheckBox.checked)
                                         : canViewPublicSpeakers
                                InterimIcon {
                                    Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                                    Layout.column: 0
                                    Layout.row: 0
                                    Layout.margins: 4
                                    source: "qrc:/icons/smartphone.svg"
                                    ToolTip.text: qsTr("Mobile")
                                    ToolTip.visible: hovered
                                }
                                ValidationTextField {
                                    id: _mobileTextField
                                    Layout.fillWidth: true
                                    horizontalAlignment: Text.AlignLeft
                                    text: currentPerson ? currentPerson.mobile : ""
                                    placeholderText: qsTr("Mobile")
                                    selectByMouse: true
                                    showClearButton: true
                                    enabled: (currentCongregation?.isLocalCongregation ?? false)
                                             ? canEditPublishers
                                             : canEditPublicSpeakers
                                }
                            }
                            GridLayout {
                                Layout.fillWidth: true
                                Layout.columnSpan: 2
                                columns: 2
                                rows: 2
                                visible: (currentCongregation?.isLocalCongregation ?? false)
                                         ? canViewPublishers || (canViewPublicSpeakers && publicTalkCheckBox.checked)
                                         : canViewPublicSpeakers
                                InterimIcon {
                                    Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                                    Layout.column: 0
                                    Layout.row: 0
                                    Layout.margins: 4
                                    source: "qrc:/icons/mail.svg"
                                    ToolTip.text: qsTr("E-mail")
                                    ToolTip.visible: hovered
                                }
                                ValidationTextField {
                                    id: _emailTextField
                                    Layout.fillWidth: true
                                    horizontalAlignment: Text.AlignLeft
                                    text: currentPerson ? currentPerson.email : ""
                                    placeholderText: qsTr("E-mail")
                                    selectByMouse: true
                                    showClearButton: true
                                    enabled: (currentCongregation?.isLocalCongregation ?? false)
                                             ? canEditPublishers
                                             : canEditPublicSpeakers
                                }
                            }
                            GridLayout {
                                Layout.fillWidth: true
                                Layout.columnSpan: 2
                                columns: 2
                                rows: 2
                                visible: (currentCongregation?.isLocalCongregation ?? false)
                                         ? canViewPublishers || (canViewPublicSpeakers && publicTalkCheckBox.checked)
                                         : canViewPublicSpeakers

                                InterimIcon {
                                    Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                                    Layout.column: 0
                                    Layout.row: 0
                                    Layout.margins: 4
                                    source: "qrc:/icons/notes.svg"
                                    ToolTip.text: qsTr("Notes")
                                    ToolTip.visible: hovered
                                }
                                ValidationTextField {
                                    id: _notesTextField
                                    Layout.fillWidth: true
                                    horizontalAlignment: Text.AlignLeft
                                    text: currentPerson ? currentPerson.info : ""
                                    placeholderText: qsTr("Notes")
                                    selectByMouse: true
                                    showClearButton: true
                                    enabled: canEditPublicSpeakers
                                             || ((currentCongregation?.isLocalCongregation ?? false) && canEditPublishers)
                                }
                            }
                            RowLayout {
                                Layout.maximumWidth: 500
                                Layout.columnSpan: 2
                                Layout.alignment: Qt.AlignLeft
                                visible: (currentCongregation?.isLocalCongregation ?? false) && canViewPublishers
                                Label {
                                    text: qsTr("Gender")
                                    Layout.fillWidth: true
                                    Layout.minimumWidth: 100
                                    horizontalAlignment: Text.AlignLeft
                                }
                                RowLayout {
                                    Layout.alignment: Qt.AlignRight | Qt.AlignVCenter
                                    Layout.preferredWidth: 300
                                    RadioButton {
                                        id: _isMaleRadioButton
                                        text: qsTr("Male")
                                        checked: currentPerson
                                                 ? currentPerson.gender === Publisher.Male
                                                 : false
                                        enabled: canEditPublishers

                                    }
                                    RadioButton {
                                        text: qsTr("Female")
                                        checked: currentPerson
                                                 ? currentPerson.gender !== Publisher.Male
                                                 : false
                                        enabled: canEditPublishers
                                    }
                                }
                                Item {
                                    Layout.fillWidth: true
                                }
                            }
                        }
                        // family
                        Label {
                            text: qsTr("Family")
                            Layout.fillWidth: true
                            Layout.columnSpan: 2
                            horizontalAlignment: Text.AlignLeft
                            font: TBStyle.titleMediumFont
                            visible: (currentCongregation?.isLocalCongregation ?? false) && canViewStudentData
                        }
                        ColumnLayout {
                            Layout.fillWidth: true
                            visible: (currentCongregation?.isLocalCongregation ?? false) && canViewStudentData
                            Switch {
                                id: _isFamilyHeadSwitch
                                Layout.columnSpan: 2
                                text: qsTr("Family head")
                                enabled: canEditPublishers
                                checked: currentPerson && currentFamily
                                         ? currentPerson.id === currentFamily.headId
                                         : false
                            }
                            RowLayout {
                                Layout.maximumWidth: 500
                                Layout.columnSpan: 2
                                Label {
                                    text: qsTr("Family member linked to")
                                    Layout.fillWidth: true
                                    Layout.minimumWidth: 100
                                    horizontalAlignment: Text.AlignLeft
                                    visible: isFamilyHeadSwitch.checked ? false : true
                                }
                                ComboBox {
                                    id: _familyHeadComboBox
                                    Layout.alignment: Qt.AlignRight | Qt.AlignVCenter
                                    Layout.preferredWidth: 300
                                    visible: isFamilyHeadSwitch.checked ? false : true
                                    enabled: canEditPublishers
                                    model: familyList
                                    textRole: "name"
                                }
                                Item {
                                    Layout.fillWidth: true
                                }
                            }
                        }
                        // privileges
                        Label {
                            text: qsTr("Privileges")
                            Layout.fillWidth: true
                            Layout.columnSpan: 2
                            horizontalAlignment: Text.AlignLeft
                            font: TBStyle.titleMediumFont
                            visible: (currentCongregation?.isLocalCongregation ?? false) && canViewPrivileges
                        }
                        ColumnLayout {
                            Layout.fillWidth: true
                            Layout.columnSpan: 2
                            visible: (currentCongregation?.isLocalCongregation ?? false) && canViewPrivileges
                            // Switch {
                            //     id: _publisherCheckBox
                            //     Layout.fillWidth: true
                            //     Layout.minimumWidth: 100
                            //     text: qsTr("Qualified to preach as")
                            //     enabled: canEditPrivileges
                            //     checked: currentPerson
                            //              && currentFamily ? currentPerson.publisher > 0 : false
                            // }
                            // ComboBox {
                            //     id: _publisherComboBox
                            //     Layout.alignment: Qt.AlignRight | Qt.AlignVCenter
                            //     Layout.preferredWidth: 300
                            //     enabled: canEditPrivileges
                            //     model: ListModel {
                            //         ListElement {
                            //             text: qsTr("Unbaptized publisher")
                            //         }
                            //         ListElement {
                            //             text: qsTr("Publisher")
                            //         }
                            //         ListElement {
                            //             text: qsTr("Auxiliary pioneer")
                            //         }
                            //         ListElement {
                            //             text: qsTr("Regular pioneer")
                            //         }
                            //         ListElement {
                            //             text: qsTr("Special pioneer")
                            //         }
                            //     }
                            // }
                            Row {
                                Layout.fillWidth: true
                                Layout.minimumWidth: 100
                                Switch {
                                    id: _servantCheckBox
                                    text: qsTr("Servant")
                                    // text: qsTr("Appointed to serve as")
                                    enabled: canEditPrivileges && isMaleRadioButton.checked
                                    checked: currentPerson?.servant ?? false
                                }
                            }
                            // ComboBox {
                            //     id: _servantComboBox
                            //     Layout.alignment: Qt.AlignRight | Qt.AlignVCenter
                            //     Layout.preferredWidth: 300
                            //     enabled: canEditPrivileges && isMaleRadioButton.checked
                            //     model: ListModel {
                            //         ListElement {
                            //             text: qsTr("Ministerial servant")
                            //         }
                            //         ListElement {
                            //             text: qsTr("Elder")
                            //         }
                            //     }
                            // }
                            Switch {
                                id: _prayerCheckBox
                                Layout.columnSpan: 2
                                text: qsTr("Prayer")
                                enabled: canEditPrivileges && currentPerson?.gender === Publisher.Male
                                checked: currentPerson
                                         ? currentPerson.usefor & Publisher.Prayer
                                         : false
                            }
                        }
                        Item {
                            Layout.fillWidth: true
                            Layout.fillHeight: true
                        }
                    }
                    ColumnLayout {
                        id: midweekTab

                        Layout.fillWidth: true
                        Layout.fillHeight: true
                        implicitWidth: parent.width
                        implicitHeight: parent.height
                        spacing: 10

                        Row {
                            Layout.fillWidth: true
                            Switch {
                                id: _midweekChairmanCheckBox
                                text: qsTr("Chairman")
                                checked: currentPerson
                                         ? currentPerson.usefor & Publisher.LMM_Chairman
                                         : false
                                enabled: canEditPrivileges && servantCheckBox.checked
                                visible: canViewPrivileges
                            }
                        }
                        // Switch {
                        //     id: _auxiliaryClassCounselorCheckBox
                        //     Layout.preferredWidth: 300
                        //     text: qsTr("Auxiliary class counselor")
                        //     checked: currentPerson
                        //              ? currentPerson.usefor & Publisher.LMM_Chairman
                        //              : false
                        //     enabled: canEditPrivileges && servantCheckBox.checked
                        //     visible: canViewPrivileges
                        // }

                        // treasures from God's Word
                        Label {
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignLeft
                            text: qsTr("Treasures From God's Word")
                            visible: canViewPrivileges || canViewStudentData
                            font: TBStyle.titleMediumFont
                        }
                        ColumnLayout {
                            Layout.fillWidth: true
                            visible: canViewPrivileges || canViewStudentData
                            Row {
                                Layout.fillWidth: true
                                Switch {
                                    id: _treasuresTalkCheckBox
                                    text: qsTr("Talk")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.LMM_TR_Talk
                                             : false
                                    visible: canViewPrivileges
                                    enabled: canEditPrivileges && servantCheckBox.checked
                                }
                            }
                            Row {
                                Layout.fillWidth: true
                                Switch {
                                    id: _spiritualGemsCheckBox
                                    text: qsTr("Spiritual Gems")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.LMM_TR_SpiritualGems
                                             : false
                                    visible: canViewPrivileges
                                    enabled: canEditPrivileges && servantCheckBox.checked
                                }
                            }
                            Row {
                                Layout.fillWidth: true
                                Switch {
                                    id: _bibleReadingCheckBox
                                    text: qsTr("Bible Reading")
                                    checked: currentPerson ? currentPerson.usefor & Publisher.LMM_TR_BibleReading : false
                                    visible: canViewStudentData
                                    enabled: canEditStudentData && currentPerson?.gender === Publisher.Male
                                }
                            }
                        }
                        // apply yourself to the field ministry
                        Label {
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignLeft
                            text: qsTr("Apply Yourself to the Field Ministry")
                            visible: canViewStudentData
                            font: TBStyle.titleMediumFont
                        }
                        GridLayout {
                            id: midweekFMSectionGridLayout
                            Layout.fillWidth: true
                            flow: GridLayout.LeftToRight
                            columns: 2
                            visible: canViewPrivileges || canViewStudentData

                            Row {
                                Layout.fillWidth: true
                                Switch {
                                    id: _startingConversationCheckBox
                                    text: qsTr("Starting a Conversation")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.LMM_FM_StartingConversation
                                             : false
                                    visible: canViewStudentData
                                    enabled: canEditStudentData
                                }
                            }
                            Row {
                                Layout.fillWidth: true
                                Switch {
                                    id: _assistantCheckBox
                                    Layout.preferredWidth: 300
                                    text: qsTr("Assistant")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.Assistant
                                             : false
                                    visible: canViewStudentData
                                    enabled: canEditStudentData
                                }
                            }
                            Row {
                                Layout.fillWidth: true
                                Switch {
                                    id: _followingUpCheckBox
                                    text: qsTr("Following Up")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.LMM_FM_FollowingUp
                                             : false
                                    visible: canViewStudentData
                                    enabled: canEditStudentData
                                }
                            }
                            ColumnLayout {
                                Layout.fillWidth: true
                                Layout.rowSpan: 3
                                Layout.preferredWidth: 300
                                RadioButton {
                                    id: _allClassesRadioButton
                                    text: qsTr("All classes")
                                    checked: currentPerson
                                             ? !(currentPerson.usefor & Publisher.SchoolMain || currentPerson.usefor & Publisher.SchoolAux)
                                             : true
                                    visible: canViewPrivileges || canViewStudentData
                                    enabled: canEditPrivileges || canEditStudentData
                                }
                                RadioButton {
                                    id: _onlyMainClassRadioButton
                                    text: qsTr("Only main hall")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.SchoolMain
                                             : false
                                    visible: canViewPrivileges || canViewStudentData
                                    enabled: canEditPrivileges || canEditStudentData
                                }
                                RadioButton {
                                    id: _onlyAuxClassRadioButton
                                    text: qsTr("Only auxiliary class")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.SchoolAux
                                             : false
                                    visible: canViewPrivileges || canViewStudentData
                                    enabled: canEditPrivileges || canEditStudentData
                                }
                            }
                            Row {
                                Layout.fillWidth: true
                                Switch {
                                    id: _makingDisciplesCheckBox
                                    text: qsTr("Making Disciples")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.LMM_FM_MakingDisciples
                                             : false
                                    visible: canViewStudentData
                                    enabled: canEditStudentData
                                }
                            }
                            Row {
                                Layout.fillWidth: true
                                Switch {
                                    id: _explainingBeliefsCheckBox
                                    text: qsTr("Explaining Your Beliefs")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.LMM_FM_ExplainingBeliefs
                                             : false
                                    visible: canViewStudentData
                                    enabled: canEditStudentData
                                }
                            }
                            Row {
                                Layout.fillWidth: true
                                Layout.columnSpan: 2
                                Switch {
                                    id: _studentTalkCheckBox
                                    text: qsTr("Talk")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.LMM_FM_Talk
                                             : false
                                    visible: canViewStudentData
                                    enabled: canEditStudentData
                                }
                            }
                            Row {
                                Layout.fillWidth: true
                                Layout.columnSpan: 2
                                Switch {
                                    id: _fmDiscussionCheckBox
                                    text: qsTr("Discussion")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.LMM_FM_Discussion
                                             : false
                                    visible: canViewPrivileges && servantCheckBox.checked
                                    enabled: canEditPrivileges && servantCheckBox.checked
                                }
                            }
                        }
                        // living as christians
                        Label {
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignLeft
                            text: qsTr("Living as Christians")
                            visible: canViewPrivileges
                            font: TBStyle.titleMediumFont
                        }
                        ColumnLayout {
                            Layout.fillWidth: true
                            visible: canViewPrivileges
                            Row {
                                Layout.fillWidth: true
                                Switch {
                                    id: _christianLivingTalkCheckBox
                                    text: qsTr("Talk or discussion")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.LMM_CL_Talk
                                             : false
                                    visible: canViewPrivileges
                                    enabled: canEditPrivileges && servantCheckBox.checked
                                }
                            }
                            Row {
                                Layout.fillWidth: true
                                Layout.preferredWidth: 300
                                Switch {
                                    id: _cbsConductorCheckBox
                                    text: qsTr("Congregation Bible Study conductor")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.CBSConductor
                                             : false
                                    visible: canViewPrivileges
                                    enabled: canEditPrivileges && servantCheckBox.checked
                                }
                            }
                            Row {
                                Layout.fillWidth: true
                                Layout.preferredWidth: 300
                                Switch {
                                    id: _cbsReaderCheckBox
                                    text: qsTr("Congregation Bible Study reader")
                                    checked: currentPerson
                                             ? currentPerson.usefor & Publisher.CBSReader
                                             : false
                                    visible: canViewPrivileges
                                    enabled: canEditPrivileges && currentPerson?.gender === Publisher.Male
                                }
                            }
                        }
                        Item {
                            Layout.fillWidth: true
                            Layout.fillHeight: true
                        }
                    }
                    ColumnLayout {
                        id: weekendTab
                        Layout.fillWidth: true
                        Layout.fillHeight: true
                        implicitWidth: parent.width
                        implicitHeight: parent.height
                        spacing: 10

                        RowLayout {
                            Layout.fillWidth: true
                            Layout.alignment: Qt.AlignTop
                            visible: canViewPublicSpeakers
                                     || ((currentCongregation?.isLocalCongregation ?? false) && canViewPrivileges)
                            ColumnLayout {
                                Layout.alignment: Qt.AlignTop
                                spacing: 10
                                Label {
                                    Layout.fillWidth: true
                                    horizontalAlignment: Text.AlignLeft
                                    text: qsTr("Public meeting")
                                    font: TBStyle.titleMediumFont
                                }
                                ColumnLayout {
                                    Layout.fillWidth: true
                                    Switch {
                                        id: _weekendChairmanCheckBox
                                        text: qsTr("Chairman")
                                        checked: currentPerson
                                                 ? currentPerson.usefor & Publisher.Chairman
                                                 : false
                                        visible: (currentCongregation?.isLocalCongregation ?? false) && canViewPrivileges
                                        enabled: servantCheckBox.checked && canEditPrivileges
                                    }
                                    Switch {
                                        id: _publicTalkCheckBox
                                        text: qsTr("Public talk")
                                        checked: currentPerson
                                                 ? currentPerson.usefor & Publisher.PublicTalk
                                                 : false
                                        visible: canViewPublicSpeakers || canViewPrivileges
                                        enabled: servantCheckBox.checked
                                                 && ((currentCongregation?.isLocalCongregation ?? false)
                                                     ? canEditPrivileges
                                                     : canEditPublicSpeakers)
                                    }
                                    Switch {
                                        id: _hostCheckBox
                                        text: qsTr("Host for public speakers")
                                        checked: currentPerson
                                                 ? currentPerson.usefor & Publisher.Hospitality
                                                 : false
                                        visible: (currentCongregation?.isLocalCongregation ?? false)
                                                 && canViewPublicSpeakers
                                        enabled: canEditPublicSpeakers
                                    }
                                }
                            }
                            ColumnLayout {
                                Layout.alignment: Qt.AlignTop
                                spacing: 10
                                visible: (currentCongregation?.isLocalCongregation ?? false) && canViewPrivileges
                                Label {
                                    Layout.fillWidth: true
                                    horizontalAlignment: Text.AlignLeft
                                    text: qsTr("Watchtower Study")
                                    font: TBStyle.titleMediumFont
                                }
                                ColumnLayout {
                                    Switch {
                                        id: _watchtowerConductorCheckBox
                                        text: qsTr("Watchtower Study conductor")
                                        checked: currentPerson
                                                 ? currentPerson.usefor & Publisher.WtCondoctor
                                                 : false
                                        visible: canViewPrivileges
                                        enabled: canEditPrivileges && servantCheckBox.checked
                                    }
                                    Switch {
                                        id: _watchtowerReaderCheckBox
                                        text: qsTr("Watchtower Study reader")
                                        checked: currentPerson
                                                 ? currentPerson.usefor & Publisher.WtReader
                                                 : false
                                        visible: canViewPrivileges
                                        enabled: canEditPrivileges
                                                 && (currentPerson
                                                     ? currentPerson.gender === Publisher.Male
                                                     : false)
                                    }
                                }
                            }
                        }
                        ColumnLayout {
                            id: publicTalksLayout
                            Layout.fillWidth: true
                            Layout.fillHeight: true
                            visible: canViewPublicSpeakers
                                     && ((currentPerson?.usefor ?? 0) & Publisher.PublicTalk)

                            Label {
                                Layout.fillWidth: true
                                horizontalAlignment: Text.AlignLeft
                                text: qsTr("Prepared talks:")
                                font: TBStyle.titleMediumFont
                            }
                            LookupControl {
                                id: _publicTalksLookupControl

                                Layout.fillWidth: true
                                Layout.fillHeight: true

                                showGroupControls: true
                                showSearchField: true
                                showEditButton: canEditPublicSpeakers
                                isEditing: false

                                model: publicTalkProxyModel
                                groupByModel: publicTalksGroupByModel

                                section.property: publicTalkProxyModel.groupByRole
                                section.criteria: ViewSection.FullString
                                section.delegate: publicTalksSectionDelegate
                                delegate: publicTalksItemDelegate

                                ScrollBar.vertical: ScrollBar {
                                    focus: true
                                }
                            }
                        }
                        Item {
                            Layout.fillWidth: true
                            Layout.fillHeight: true
                            visible: !publicTalksLayout.visible
                        }
                    }
                    ColumnLayout {
                        id: unavailabilityTab
                        Layout.fillHeight: true
                        Layout.fillWidth: true
                        implicitWidth: parent.width
                        implicitHeight: parent.height
                        spacing: 10
                        Row {
                            Layout.fillWidth: true
                            Switch {
                                id: _isBreakCheckBox
                                text: qsTr("Break")
                                enabled: canEditAvailabilities
                                checked: currentPerson ? currentPerson.usefor
                                                         & Publisher.IsBreak : false
                            }
                        }
                        Label {
                            Layout.fillWidth: true
                            horizontalAlignment: Text.AlignLeft
                            text: qsTr("Unavailable dates")
                            font: TBStyle.titleMediumFont
                        }
                        UnavailabilityEditor {
                            id: _unavailabilityEditor
                            Layout.fillHeight: true
                            Layout.fillWidth: true
                        }
                    }
                    ColumnLayout {
                        id: historyTab
                        Layout.fillHeight: true
                        Layout.fillWidth: true
                        implicitWidth: parent.width
                        implicitHeight: parent.height
                        spacing: 10
                        Row {
                            Layout.fillWidth: true
                            Switch {
                                id: _isLoadingMidweekPartsCheckBox
                                text: qsTr("Display midweek meeting parts")
                                checked: true
                            }
                        }
                        Row {
                            Layout.fillWidth: true
                            Switch {
                                id: _isLoadingWeekendPartsCheckBox
                                text: qsTr("Display weekend meeting parts")
                                checked: true
                            }
                        }
                        LookupControl {
                            id: _historyLookupControl
                            Layout.fillHeight: true
                            Layout.fillWidth: true
                            showEditButton: false
                            isEditing: false
                            showGroupControls: true
                            showSearchField: true
                            showFilterControls: true

                            model: historyProxyModel
                            filterModel: historyDetailFilterModel
                            groupByModel: historyDetailGroupByModel
                            moreMenu: historyLookupControlMoreMenu

                            section.property: "year"
                            section.criteria: ViewSection.FullString
                            section.delegate: historySectionDelegate
                            delegate: historyItemDelegate

                            ScrollBar.vertical: ScrollBar {
                                focus: true
                            }
                        }
                    }
                }
            }
        }
    }
}
