#ifndef PUBLICTALK_H
#define PUBLICTALK_H

#include <QAbstractListModel>
#include <QObjectBindableProperty>
#include <QSortFilterProxyModel>
#include <QtMath>
#include <QValidator>
#include "sql_class.h"
#include "accesscontrol.h"

class PublicTalk : public QObject
{
    Q_OBJECT
    Q_PROPERTY(int publicTalkId READ publicTalkId CONSTANT)
    Q_PROPERTY(int themeNumber READ themeNumber WRITE setThemeNumber BINDABLE bindableThemeNumber)
public:
    PublicTalk();
    PublicTalk(const int id, const int themeNumber, const QString themeName, const QString revision,
               const QDate releaseDate, const QDate discontinueDate, const int languageId,
               const QString language, const bool isSelected, QObject *parent = nullptr);

    int publicTalkId() const;

    int themeNumber() { return b_themeNumber.value(); }
    void setThemeNumber(int newValue) { b_themeNumber = newValue; }
    QBindable<int> bindableThemeNumber() { return &b_themeNumber; }

    const QString themeNumberRange(int step) const;

    QString themeName() { return b_themeName.value(); }
    void setThemeName(QString newValue) { b_themeName = newValue; }
    QBindable<QString> bindableThemeName() { return &b_themeName; }

    QString revision() { return b_revision.value(); }
    void setRevision(QString newValue) { b_revision = newValue; }
    QBindable<QString> bindableRevision() { return &b_revision; }

    QDate releaseDate() { return b_releaseDate.value(); }
    void setReleaseDate(QDate newValue) { b_releaseDate = newValue; }
    QBindable<QDate> bindableReleaseDate() { return &b_releaseDate; }

    QDate discontinueDate() { return b_discontinueDate.value(); }
    void setDiscontinueDate(QDate newValue) { b_discontinueDate = newValue; }
    QBindable<QDate> bindableDiscontinueDate() { return &b_discontinueDate; }

    int languageId() { return b_languageId.value(); }
    void setLanguageId(int newValue) { b_languageId = newValue; }
    QBindable<int> bindableLanguageId() { return &b_languageId; }

    QString language() { return b_language.value(); }
    void setLanguage(QString newValue) { b_language = newValue; }
    QBindable<QString> bindableLanguage() { return &b_language; }

    int isSelected() { return b_isSelected.value(); }
    void setIsSelected(int newValue) { b_isSelected = newValue; }
    QBindable<int> bindableIsSelected() { return &b_isSelected; }

signals:
    void themeNumberChanged();
    void themeNameChanged();
    void revisionChanged();
    void releaseDateChanged();
    void discontinueDateChanged();
    void languageIdChanged();
    void languageChanged();
    void isSelectedChanged();

private:
    int m_publicTalkId;
    Q_OBJECT_BINDABLE_PROPERTY(PublicTalk, int, b_themeNumber, &PublicTalk::themeNumberChanged);
    Q_OBJECT_BINDABLE_PROPERTY(PublicTalk, QString, b_themeName, &PublicTalk::themeNameChanged);
    Q_OBJECT_BINDABLE_PROPERTY(PublicTalk, QString, b_revision, &PublicTalk::revisionChanged);
    Q_OBJECT_BINDABLE_PROPERTY(PublicTalk, QDate, b_releaseDate, &PublicTalk::releaseDateChanged);
    Q_OBJECT_BINDABLE_PROPERTY(PublicTalk, QDate, b_discontinueDate, &PublicTalk::discontinueDateChanged);
    Q_OBJECT_BINDABLE_PROPERTY(PublicTalk, int, b_languageId, &PublicTalk::languageIdChanged);
    Q_OBJECT_BINDABLE_PROPERTY(PublicTalk, QString, b_language, &PublicTalk::languageChanged);
    Q_OBJECT_BINDABLE_PROPERTY(PublicTalk, bool, b_isSelected, &PublicTalk::isSelectedChanged);
};

class PublicTalkModel : public QAbstractTableModel
{
    Q_OBJECT

    Q_PROPERTY(int length READ rowCount NOTIFY modelChanged)
public:
    explicit PublicTalkModel(QObject *parent = nullptr);
    ~PublicTalkModel();

    enum Roles {
        None = 0,
        PublicTalkIdRole = Qt::UserRole,
        PublicTalkRole,
        ThemeNumberRole,
        ThemeNumberRangeRole,
        ThemeNameRole,
        AlphabetRole,
        RevisionRole,
        ReleaseDateRole,
        DiscontinueDateRole,
        LanguageIdRole,
        LanguageRole,
        IsSelectedRole
    };
    Q_ENUM(Roles)

    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;

    QHash<int, QByteArray> roleNames() const;

    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE bool setData(const QModelIndex &index, const QVariant &value, int role = Qt::EditRole);

    Q_INVOKABLE QVariantMap get(int row) const;

    Q_INVOKABLE QModelIndex getPublicTalkIndex(int publicTalkId) const;

    int addPublicTalk(PublicTalk *publicTalk);
    Q_INVOKABLE void loadPublicTalks(int personId = 0);

    Q_INVOKABLE void saveSpeakersTalks(int speakerId);
signals:
    void modelChanged();

private:
    QList<PublicTalk *> publicTalks;
};

class PublicTalkSortFilterProxyModel : public QSortFilterProxyModel
{
    Q_OBJECT
    Q_PROPERTY(QObject *source READ source WRITE setSource NOTIFY sourceChanged)
    Q_PROPERTY(QString filterText READ filterText WRITE setFilterText NOTIFY filterTextChanged)
    Q_PROPERTY(bool isUnselectedDisplayed READ isUnselectedDisplayed WRITE setIsUnselectedDisplayed NOTIFY isUnselectedDisplayedChanged)
    Q_PROPERTY(QByteArray sortRole READ sortRole WRITE setSortRole NOTIFY sortChanged)
    Q_PROPERTY(QByteArray groupByRole READ groupByRole WRITE setGroupByRole NOTIFY groupByChanged)

public:
    PublicTalkSortFilterProxyModel(QObject *parent = nullptr);

    QObject *source() const;
    void setSource(QObject *source);

    QString filterText() const;
    void setFilterText(QString newValue);

    bool isUnselectedDisplayed() const;
    void setIsUnselectedDisplayed(bool newValue);

    QByteArray sortRole() const;
    void setSortRole(const QByteArray &role);

    QByteArray groupByRole() const;
    void setGroupByRole(const QByteArray &role);

    Q_INVOKABLE virtual void sort(int column, Qt::SortOrder order = Qt::DescendingOrder) override
    {
        QSortFilterProxyModel::sort(column, order);
    }

protected:
    bool filterAcceptsRow(int sourceRow, const QModelIndex &sourceParent) const override;
    bool lessThan(const QModelIndex &left, const QModelIndex &right) const override;
    int roleKey(const QByteArray &role) const;

signals:
    void sourceChanged();
    void filterTextChanged();
    void isUnselectedDisplayedChanged();
    void sortChanged();
    void groupByChanged();

private:
    QString m_filterText;
    QByteArray m_groupByRole;
    bool m_isUnselectedDisplayed;
};

class PublicTalkValidator : public QValidator
{
    Q_OBJECT
    Q_PROPERTY(PublicTalkModel *model READ model WRITE setModel NOTIFY modelChanged)
    Q_PROPERTY(int talkId READ talkId WRITE setTalkId NOTIFY talkIdChanged)
    Q_PROPERTY(PublicTalkModel::Roles role READ role WRITE setRole NOTIFY roleChanged)
public:
    PublicTalkValidator(QObject *parent = nullptr);
    ~PublicTalkValidator();

    QValidator::State validate(QString &input, int &pos) const override;

    PublicTalkModel *model() const;
    void setModel(PublicTalkModel *newModel);

    PublicTalkModel::Roles role() const;
    void setRole(PublicTalkModel::Roles newRole);

    int talkId() const;
    void setTalkId(int newTalkId);

Q_SIGNALS:
    void modelChanged();
    void talkIdChanged();
    void errorChanged(const QString &error) const;
    void roleChanged();

private:
    PublicTalkModel *m_model;
    int m_talkId;
    PublicTalkModel::Roles m_role;
};

#endif // PUBLICTALK_H
