#include "personComboBox.h"

PersonComboBox::PersonComboBox(QObject *parent)
    : QItemDelegate(parent)
{
}

QWidget *PersonComboBox::createEditor(QWidget *parent,
                                      const QStyleOptionViewItem &option,
                                      const QModelIndex &index) const
{
    Q_UNUSED(option);
    Q_UNUSED(index);
    QComboBox *editor = new QComboBox(parent);
    editor->addItem("");
    editor->setItemData(editor->count() - 1, 0, Qt::UserRole);

    cpersons cp;
    auto persons = cp.getAllPersons(0);

    // Add publishers to list
    for (Person *p : persons) {
        editor->addItem(p->fullName());
        editor->setItemData(editor->count() - 1, p->id(), Qt::UserRole);
    }
    QTimer::singleShot(0, editor, &QComboBox::showPopup);
    return editor;
}

void PersonComboBox::setEditorData(QWidget *editor,
                                   const QModelIndex &index) const
{
    QComboBox *cb = static_cast<QComboBox *>(editor);
    cb->setCurrentText(index.model()->data(index, Qt::EditRole).toString());
    // cb->showPopup();
}

void PersonComboBox::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
{
    QComboBox *cb = static_cast<QComboBox *>(editor);
    model->setData(index, cb->currentText(), Qt::EditRole);
    int personId = cb->itemData(cb->currentIndex(), Qt::UserRole).toInt();
    model->setData(index, personId, Qt::UserRole);
}

void PersonComboBox::updateEditorGeometry(QWidget *editor,
                                          const QStyleOptionViewItem &option,
                                          const QModelIndex & /* index */) const
{
    editor->setGeometry(option.rect);
}

personTextEdit::personTextEdit(QObject *parent)
    : QItemDelegate(parent)
{
}

QWidget *personTextEdit::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    Q_UNUSED(option);
    Q_UNUSED(index);
    return new QTextEdit(parent);
}

void personTextEdit::setEditorData(QWidget *editor, const QModelIndex &index) const
{
    QTextEdit *txt = static_cast<QTextEdit *>(editor);
    txt->setHtml("<HTML><BODY>" + index.model()->data(index, Qt::EditRole).toString().replace("\r\n", "<br>").replace("\n", "<br>") + "</BODY></HTML>");
}

void personTextEdit::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
{
    QTextEdit *txt = static_cast<QTextEdit *>(editor);
    model->setData(index, txt->toPlainText(), Qt::EditRole);
}

void personTextEdit::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &) const
{
    editor->setGeometry(option.rect);
}
