!versionAtLeast(QT_VERSION, 6.10.0):error("Qt 6.10 required")

TEMPLATE = app
QT += qml quick widgets sql network svg networkauth webview quickcontrols2 core5compat location positioning xml concurrent
TARGET = TheocBase
CONFIG += c++17
CONFIG -= bitcode

VERSION = 2025.01.1         # Version name (user-visible version)
BUILD_NUMBER = 11           # Version code (version name without dots appended by build number; for Google Play)
DEFINES += APP_VERSION=\\\"$$VERSION\\\"
DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060800

# C++ files
include(src/src.pri)

# Default rules for deployment.
include(deployment.pri)
# SMTP Client
include(../smtp/smtpclient.pri)

SOURCES +=
HEADERS +=

RESOURCES += \
    ../images.qrc \
    qml/qml.qrc \
    ../database.qrc \
    ../osmRepository.qrc \
    translations/translations_mobile.qrc \
    ../translations/translations.qrc \
    ../fonts/fonts.qrc

# var, prepend, append
defineReplace(prependAll) {
    for(a,$$1):result += $$2$${a}$$3
    return($$result)
}

lupdate_only {
    TR_EXCLUDE += $$PWD/../accesscontrol.*
    SOURCES = qml/*.qml \
        src/school_detail.cpp
}

# Supported languages
LANGUAGES = af az_AZ bg cpe_011 cs da de de_LU ee en es et el fi fr cpf_gcf gn he hi hr ht hu hy it ka lt my_MM ne nl no pl pt pt_BR pa pa_PK ro ru sk sl sr sv sw ta th_TH tl tr_TR uk zh xh

# Available translations
TRANSLATIONS = $$prependAll(LANGUAGES, $$PWD/translations/theocbase_mobile_, .ts)

# Additional import path used to resolve QML modules in Qt Creator's code model
# QML_IMPORT_PATH =
