#ifndef TERRITORYMANAGER_H
#define TERRITORYMANAGER_H

#include "qobject.h"
#include "qtmetamacros.h"
#include "../../sql_class.h"
#include "../../dataobject.h"

class TerritoryManager : public QObject
{
    Q_OBJECT
public:
    TerritoryManager();

    Q_INVOKABLE void initialize();

    DataObjectListModel *typeListModel() const;
    DataObjectListModel *cityListModel() const;
    QString defaultGeoServiceProviderName() const;
    QVariantMap geoServiceParameters() const;

private:
    sql_class *sql;
    DataObjectListModel *m_typeListModel;
    DataObjectListModel *m_cityListModel;
    QString m_defaultGeoServiceProviderName;
    QVariantMap m_geoServiceParameters;
};

#endif // TERRITORYMANAGER_H
