#include "territorymanager.h"
#include "../../cterritories.h"

TerritoryManager::TerritoryManager()
{
    initialize();
}

void TerritoryManager::initialize()
{
    // list of territory-types
    sql_class *sql = &Singleton<sql_class>::Instance();
    sql_items typeItems = sql->selectSql("SELECT * FROM territory_type WHERE active = 1 ORDER BY id;");
    m_typeListModel = new DataObjectListModel();
    m_typeListModel->addDataObject(DataObject(-1, " "));
    for (unsigned int i = 0; i < typeItems.size(); i++) {
        m_typeListModel->addDataObject(DataObject(typeItems[i].value("id").toInt(),
                                                  typeItems[i].value("type_name").toString()));
    }
    // list of cities
    sql_items cityItems = sql->selectSql("SELECT * FROM territory_city WHERE active = 1 ORDER BY city;");
    m_cityListModel = new DataObjectListModel();
    m_cityListModel->addDataObject(DataObject(-1, " "));
    for (unsigned int i = 0; i < cityItems.size(); i++) {
        m_cityListModel->addDataObject(DataObject(cityItems[i].value("id").toInt(),
                                                  cityItems[i].value("city").toString()));
    }
    // geo services
    QSettings settings;
    int defaultGeoServiceProvider = settings.value("geo_service_provider/default", 0).toInt();
    // set plugin parameters for the map, and use OSM (0) when Google (1) is selected as default
    m_defaultGeoServiceProviderName = (new QString[] { "osm", "osm", "here" })[defaultGeoServiceProvider];
    cterritories *t = new cterritories;
    m_geoServiceParameters = t->setupGeoServices(defaultGeoServiceProvider);
}

DataObjectListModel *TerritoryManager::typeListModel() const
{
    return m_typeListModel;
}

DataObjectListModel *TerritoryManager::cityListModel() const
{
    return m_cityListModel;
}

QString TerritoryManager::defaultGeoServiceProviderName() const
{
    return m_defaultGeoServiceProviderName;
}

QVariantMap TerritoryManager::geoServiceParameters() const
{
    return m_geoServiceParameters;
}
