/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2019, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase.mobile 1.0

Page {
    id: wtStudyEdit
    title: "Watchtower Study"
    property CPTMeeting meeting
    onMeetingChanged: {
        if (meeting)
            wt_controller.date = meeting.date
    }
    property PublicMeetingController wt_controller: PublicMeetingController {}
    header: BaseToolbar {
        title: wtStudyEdit.title
        componentLeft: ToolButton {
            icon.source: "qrc:/icons/back.svg"
            onClicked: {
                stackView.pop()
            }
        }
    }

    ScrollView {
        width: parent.width
        height: parent.height
        contentWidth: width

        Pane {
            width: wtStudyEdit.availableWidth
            ColumnLayout {
                id: layout
                width: parent.width
                spacing: 16

                // Issue
                FilledGroupBox {
                    Layout.fillWidth: true
                    title: qsTr("Watchtower")

                    Column {
                        width: parent.width
                        RowLayout {
                            width: parent.width
                            InterimIcon {
                                Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                                source: "qrc:/icons/wt_source.svg"
                                color: Material.foreground
                                ToolTip.text: qsTr("Watchtower Issue")
                            }
                            NumberSelector {
                                maxValue: 12
                                Layout.fillWidth: true
                                Layout.preferredHeight: height
                                selectedValue: meeting.wtIssue == ""  ? 0 : parseInt(meeting.wtIssue)
                                onSelectedValueChanged: {
                                    var checkValue = 0
                                    if (meeting.wtIssue != "")
                                        checkValue = parseInt(meeting.wtIssue)
                                    if (selectedValue !== checkValue) {
                                        meeting.wtIssue = selectedValue
                                        meeting.save()
                                    }
                                }
                            }
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowLayout {
                            width: parent.width
                            InterimIcon {
                                Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                                source: "qrc:/icons/123.svg"
                                color: Material.foreground
                                ToolTip.text: qsTr("Article", "The number of Watchtower article")
                            }
                            TextField {
                                Layout.fillWidth: true
                                Material.containerStyle: Material.Filled
                                leftPadding: 10
                                rightPadding: 10
                                text: meeting.wtSource
                                //enabled: false
                                visible: meeting.date > new Date("2019-03-03")
                                onEditingFinished: {
                                    if (meeting.wtSource !== text) {
                                        meeting.wtSource = text
                                        meeting.save()
                                    }
                                }
                            }
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowLayout {
                            width: parent.width
                            InterimIcon {
                                Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                                source: "qrc:/icons/title.svg"
                                color: Material.foreground
                                ToolTip.text: qsTr("Theme")
                            }
                            TextField {
                                text: meeting.wtTheme
                                Layout.fillWidth: true
                                Material.containerStyle: Material.Filled
                                leftPadding: 10
                                rightPadding: 10
                                wrapMode: Text.WordWrap
                                onEditingFinished: {
                                    if (meeting.wtTheme !== text) {
                                        meeting.wtTheme = text
                                        meeting.save()
                                    }
                                }
                            }
                        }
                    }
                }
                // WT Conductor
                FilledGroupBox {
                    id: conductorGroupBox
                    Layout.fillWidth: true
                    title: qsTr("Conductor", "Watchtower study conductor")

                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                            source: "qrc:/icons/speaker.svg"
                            color: Material.foreground
                        }
                        ComboBoxTable {
                            Layout.fillWidth: true
                            currentText: meeting.wtConductor ? meeting.wtConductor.fullName : ""
                            currentId: meeting.wtConductor ? meeting.wtConductor.id : -1
                            col1Name: conductorGroupBox.title
                            onBeforeMenuShown: {
                                model = wt_controller.brotherList(Publisher.WtCondoctor)
                            }
                            onRowSelected: {
                                var wtconductor = CPersons.getPerson(id)
                                meeting.wtConductor = wtconductor
                                meeting.save()
                            }
                        }
                    }
                }
                // WT Reader
                FilledGroupBox {
                    id: readerGroupBox
                    Layout.fillWidth: true
                    title: qsTr("Reader", "Watchtower study reader")

                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                            source: "qrc:/icons/reader.svg"
                            color: Material.foreground
                        }
                        ComboBoxTable {
                            Layout.fillWidth: true
                            currentText: meeting.wtReader ? meeting.wtReader.fullName : ""
                            currentId: meeting.wtReader ? meeting.wtReader.id : -1
                            col1Name: readerGroupBox.title
                            onBeforeMenuShown: {
                                model = wt_controller.brotherList(Publisher.WtReader)
                            }
                            onRowSelected: {
                                var wtreader = CPersons.getPerson(id)
                                meeting.wtReader = wtreader
                                meeting.save()
                            }
                        }
                    }
                }
            }
        }
    }
}
