/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2019, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick
import QtQuick.Window
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase.mobile 1.0

Page {
    id: wtSongEdit
    title: qsTr("Watchtower Song", "Page title")

    property CPTMeeting meeting
    property bool startSong: true

    header: BaseToolbar {
        title: wtSongEdit.title
        componentLeft: ToolButton {
            icon.source: "qrc:/icons/back.svg"
            onClicked: {
                stackView.pop()
            }
        }
    }


    ScrollView {
        width: parent.width
        height: parent.height
        contentWidth: layout.width

        Pane {
            width: wtSongEdit.availableWidth
            Column {
                id: layout
                width: parent.width
                spacing: 16
                // Prayer
                FilledGroupBox {
                    id: chairmanGroupBox
                    width: parent.width
                    title: qsTr("Prayer")
                    visible: !startSong

                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                            source: "qrc:/icons/person.svg"
                            color: Material.foreground
                        }
                        ComboBoxTable {
                            Layout.fillWidth: true
                            Layout.bottomMargin: 10
                            currentText: meeting?.finalPrayer ? meeting.finalPrayer.fullName : ""
                            currentId: meeting?.finalPrayer ? meeting.finalPrayer.id : -1
                            col1Name: chairmanGroupBox.title
                            visible: !startSong
                            onBeforeMenuShown: {
                                model = controller.brotherList(Publisher.Prayer)
                            }
                            onRowSelected: {
                                var prayer = CPersons.getPerson(id)
                                meeting.finalPrayer = prayer
                                meeting.save()
                            }
                            PublicMeetingController { id: controller }
                        }
                    }
                }

                FilledGroupBox {
                    width: parent.width
                    title: qsTr("Song")
                    visible: specialEventRule ? !specialEventRule.isWithoutPublicTalk : false

                    RowLayout {
                        width: parent.width
                        NumberSelector {
                            Layout.fillWidth: true
                            Layout.preferredHeight: height
                            Layout.topMargin: 16
                            Layout.bottomMargin: 16
                            maxValue: meeting ? meeting.getMaxSongNumber() : 0
                            selectedValue: startSong ? meeting?.songWtStart : meeting?.songWtEnd
                            onSelectedValueChanged: {
                                if (startSong) {
                                    if (selectedValue === meeting.songWtStart)
                                        return
                                    meeting.songWtStart = selectedValue
                                } else {
                                    if (selectedValue === meeting.songWtEnd)
                                        return
                                    meeting.songWtEnd = selectedValue
                                }
                                meeting.save()
                            }
                        }
                    }
                }
            }
        }
    }
}
