/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2019, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Layouts
import net.theocbase.mobile 1.0

Page {
    id: chairmanEdit
    title: qsTr("Weekend Meeting Chairman", "Page title")
    property SpecialEventRule specialEventRule
    property CPTMeeting meeting
    onMeetingChanged: {
        if (meeting)
            controller.date = meeting.date
    }
    header: BaseToolbar {
        title: chairmanEdit.title
        componentLeft: ToolButton {
            icon.source: "qrc:/icons/back.svg"
            onClicked: {
                stackView.pop()
            }
        }
    }

    ScrollView {
        width: parent.width
        height: parent.height
        contentWidth: width

        Pane {
            width: chairmanEdit.availableWidth
            Column {
                id: layout
                width: parent.width
                spacing: 16

                // Chairman
                FilledGroupBox {
                    id: chairmanGroupBox
                    width: parent.width
                    title: qsTr("Chairman")

                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                            source: "qrc:/icons/speaker.svg"
                            color: Material.foreground
                        }
                        ComboBoxTable {
                            Layout.fillWidth: true
                            currentText: meeting.chairman ? meeting.chairman.fullName : ""
                            currentId: meeting.chairman ? meeting.chairman.id : -1
                            col1Name: chairmanGroupBox.title
                            onBeforeMenuShown: {
                                model = controller.brotherList(Publisher.Chairman)
                            }
                            onRowSelected: {
                                var chairman = CPersons.getPerson(id)
                                meeting.chairman = chairman
                                meeting.save()
                            }
                            PublicMeetingController { id: controller }
                        }
                    }
                }

                // Song
                FilledGroupBox {
                    width: parent.width
                    title: qsTr("Song")
                    visible: specialEventRule ? !specialEventRule.isWithoutPublicTalk : false

                    RowLayout {
                        width: parent.width
                        NumberSelector {
                            Layout.fillWidth: true
                            Layout.preferredHeight: height
                            Layout.topMargin: 16
                            Layout.bottomMargin: 16
                            maxValue: meeting.getMaxSongNumber()
                            selectedValue: meeting.songTalk
                            visible: specialEventRule ? !specialEventRule.isWithoutPublicTalk : false
                            onSelectedValueChanged: {
                                if (selectedValue !== meeting.songTalk) {
                                    meeting.songTalk = selectedValue
                                    meeting.save()
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
