import QtCore
import QtQuick
import QtQuick.Window
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase.mobile 1.0
import "."
import "sidePanelScripts.js" as SPScripts

SwipeDelegate {
    id: territoryStreetDelegate

    // PROPERTY DECLARATIONS
    property bool isValidationTextVisible: false
    property bool isStreetNameLoading: true
    property bool isStreetTypeLoading: true
    property bool isHouseNumberLoading: true

    // SIGNAL DECLARATIONS

    // OBJECT PROPERTIES
    leftPadding: 0
    width: LookupControl.view.width
    height: delegateContent.implicitHeight + topPadding + bottomPadding
    highlighted: LookupControl.view.currentIndex === index
    hoverEnabled: LookupControl.view.hoverEnabled

    // child objects
    TerritoryStreetValidator {
        id: streetNameValidator
        model: territoryStreetDelegate.LookupControl.view.model.source
        streetId: streetId
        role: TerritoryStreetModel.StreetNameRole
        onErrorChanged: function(error) { streetNameErrorLabel.text = error }
        onStreetIdChanged: {
            isValidationTextVisible = false;
            isStreetNameLoading = true;
            isStreetNameLoading = false;
        }
    }
    TerritoryStreetValidator {
        id: streetTypeValidator
        model: territoryStreetDelegate.LookupControl.view.model.source
        streetId: streetId
        role: TerritoryStreetModel.StreetTypeIdRole
        onErrorChanged: function(error) { streetTypeErrorLabel.text = error }
        onStreetIdChanged: {
            isValidationTextVisible = false;
            isStreetTypeLoading = true;
            isStreetTypeLoading = false;
        }
    }
    TerritoryStreetValidator {
        id: fromNumberValidator
        model: territoryStreetDelegate.LookupControl.view.model.source
        streetId: streetId
        role: TerritoryStreetModel.FromNumberRole
        onErrorChanged: function(error) { fromNumberErrorLabel.text = error }
        onStreetIdChanged: {
            isValidationTextVisible = false;
            isHouseNumberLoading = true;
            isHouseNumberLoading = false;
        }
    }
    TerritoryStreetValidator {
        id: toNumberValidator
        model: territoryStreetDelegate.LookupControl.view.model.source
        streetId: streetId
        role: TerritoryStreetModel.ToNumberRole
        onErrorChanged: function(error) { toNumberErrorLabel.text = error }
        onStreetIdChanged: {
            isValidationTextVisible = false;
            isHouseNumberLoading = true;
            isHouseNumberLoading = false;
        }
    }

//    Connections {
//        target: territoryStreetDelegate.LookupControl.view.model
//        function onSortChanged() {
//            isValidationTextVisible = false;
//        }
//        function onGroupByChanged() {
//            isValidationTextVisible = false;
//        }
//        function onFilterTextChanged() {
//            isValidationTextVisible = false;
//        }
//    }
    Connections {
        target: territoryStreetDelegate.LookupControl.view.model.source
        function onModelChanged() {
            isValidationTextVisible = false;
        }
    }

    swipe.enabled: canEditTerritories
    swipe.right: Label {
        id: deleteLabel
        text: qsTr("Delete")
        color: "white"
        verticalAlignment: Label.AlignVCenter
        padding: 12
        height: parent.height
        anchors.right: parent.right

        SwipeDelegate.onClicked: {
            streetModel.removeStreet(streetId);
        }

        background: Rectangle {
            color: deleteLabel.SwipeDelegate.pressed ? Qt.darker("tomato", 1.1) : "tomato"
        }
    }

    contentItem: Row {
        spacing: 5

        Rectangle {
            width: 5
            height: parent.height
            color: streetTypeColor
        }
        Column {
            width: parent.width
            GridLayout {
                id: delegateContent
                width: parent.width
                columns: 2
                rows: 4

                Item {
                    Layout.fillHeight: true
                    Layout.columnSpan: 2
                }
                Label {
                    Layout.fillWidth: true
                    Layout.alignment: Qt.AlignVCenter | Qt.AlignLeft
                    horizontalAlignment: Text.AlignLeft
                    text: streetName
                }
                InfoBox {
                    id: quantityInfoBox
                    Layout.alignment: Qt.AlignTop | Qt.AlignRight
                    Layout.margins: 0
                    topInset: 0
                    bottomInset: 0
                    leftInset: 0
                    rightInset: 0

                    backgroundColor: TBStyle.primaryTextColor
                    textColor: myPalette.window
                    Material.roundedScale: Material.LargeScale
                    text: quantity
                    visible: quantity > 0
                }
                Row {
                    Layout.alignment: Qt.AlignVCenter | Qt.AlignLeft
                    Label {
                        anchors.verticalCenter: parent.verticalCenter
                        horizontalAlignment: Text.AlignLeft
                        text: fromNumber
                    }
                    Label { text: " - "; visible: fromNumber !== "" && toNumber !== "" }
                    Label {
                        anchors.verticalCenter: parent.verticalCenter
                        horizontalAlignment: Text.AlignLeft
                        text: toNumber
                    }
                }
                Label {
                    Layout.fillWidth: true
                    Layout.alignment: Qt.AlignVCenter | Qt.AlignRight
                    horizontalAlignment: Text.AlignRight
                    text: streetTypeName
                }
                Item {
                    Layout.fillHeight: true
                    Layout.columnSpan: 2
                }
            }

            // error labels
            Label {
                id: streetNameErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
            Label {
                id: streetTypeErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
            Label {
                id: fromNumberErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
            Label {
                id: toNumberErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
            Label {
                id: nameErrorLabel
                font: TBStyle.bodySmallFont
                color: TBStyle.alertColor
                visible: text
            }
        }
    }

    onClicked: {
        if (streetId > 0) {
            if (territoryManager.currentStreet?.streetId !== streetId) {
                territoryManager.currentStreet = streetModel.findStreet(streetId);
            } else {
                zoomSelectedStreet();
            }
        }
        LookupControl.view.currentIndex = index;
    }
}
