import QtQuick
import QtLocation
import QtPositioning
import QtQuick.Controls
import net.theocbase 1.0

MapItemView {
    id: mapItemView

    required property int territoryId
    required property string streetTypeColor
    required property var multiLine
    required property var street
    property bool isTerritorySelected: false
    property bool isStreetSelected: false
    property int lineWidth: 7

    delegate: MapPolyline {
        id: mainPolyline

        line.width: lineWidth
        line.color: isStreetSelected ? "#ff0000" : mapItemView.streetTypeColor
        opacity: 0.3

        path: modelData

        states: [
            State {
                name: "Unassigned"; when: territoryId == 0
                PropertyChanges { target: mainPolyline; opacity: 0.4; visible: true; line.color: 'orange' }
            },
            State {
                name: "IsTerritorySelected"; when: isTerritorySelected && streetLayer.streetDisplayOption >= 1
                PropertyChanges { target: mainPolyline; opacity: 0.4; visible: true }
            },
            State {
                name: "IsNotSelected"; when: !isTerritorySelected && streetLayer.streetDisplayOption === 2
                PropertyChanges { target: mainPolyline; opacity: 0.2; visible: true }
            },
            State {
                name: "Hidden"; when: streetLayer.streetDisplayOption == 0 || (streetLayer.streetDisplayOption == 1 && !isTerritorySelected)
                PropertyChanges { target: mainPolyline; opacity: 0; visible: false }
            }
        ]

        TapHandler {
            id: tapHandler
            // gesturePolicy: TapHandler.ReleaseWithinBounds
            onTapped: {
                territoryManager.currentTerritory = territoryTreeModel.findTerritory(territoryId);
                territoryManager.currentStreet = streetModel.findStreet(street.streetId);
            }
        }
    }
}
