import QtQuick
import QtLocation
import QtPositioning

SimpleMarker {
    id: myMapMarker

    visible: false

    property int territoryId
    property int addressId
    property bool isTerritorySelected: false

    states: [
        State {
            name: "Unassigned"; when: territoryId == 0
            PropertyChanges { target: myMapMarker; opacity: 1; visible: true; color: 'black' }
        },
        State {
            name: "IsTerritorySelected"; when: isTerritorySelected && addressLayer.markerDisplayOption >= 1
            PropertyChanges { target: myMapMarker; opacity: 1; visible: true }
        },
        State {
            name: "IsNotSelected"; when: !isTerritorySelected && addressLayer.markerDisplayOption === 2
            PropertyChanges { target: myMapMarker; opacity: 0.5; visible: true }
        },
        State {
            name: "Hidden"; when: addressLayer.markerDisplayOption == 0 || (addressLayer.markerDisplayOption == 1 && !isTerritorySelected)
            PropertyChanges { target: myMapMarker; opacity: 0; visible: false }
        }
    ]

    TapHandler {
        id: tapHandler
        onTapped: (eventPoint, button)=> {
            if (button === Qt.RightButton) {
                contextMenu.show(myMapMarker, myMapMarker.territoryId, myMapMarker.addressId);
                return;
            }

            if (addressId > 0) {
                if (territoryManager.currentTerritory === null
                        || territoryManager.currentTerritory.territoryId !== territoryId) {
                    territoryManager.currentTerritory = territoryTreeModel.findTerritory(territoryId);
                }
                territoryManager.currentAddress = addressModel.findAddress(addressId);
            }
        }
    }

    isMarkerDragTarget: vectorLayer.editMode === 2

    DragHandler {
        id: dragHandler
        grabPermissions: PointerHandler.CanTakeOverFromItems | PointerHandler.CanTakeOverFromHandlersOfDifferentType
        enabled: isClickable && vectorLayer.editMode === 2
        onGrabChanged: (transition, point) => {
            if (vectorLayer.editMode === 2 && point.state === Qt.TouchPointReleased) {
                addressModel.updateAddress(addressId, "POINT(" + coordinate.longitude + " " + coordinate.latitude + ")");
            }
        }
    }
}
