
/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2024, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Layouts
import QtQml.Models
import QtPositioning
import QtLocation
import net.theocbase.mobile 1.0
import net.theocbase 1.0

Page {
    id: root

    property alias sidebar: sidebar
    property alias showSidePanelButton: showSidePanelButton
    property alias busyIndicator: _busyIndicator
    property alias mapView: territoryMapLoader.item
    property alias itemView: itemView
    property alias splitView: splitView

    // CHILD OBJECTS
    SystemPalette {
        id: myPalette
        colorGroup: SystemPalette.Active
    }

    Item {
        id: mapItem

        Layout.fillWidth: true
        Layout.fillHeight: true
        clip: true
        Loader {
            id: territoryMapLoader

            anchors.fill: parent
            anchors.leftMargin: 5
            // Layout.fillHeight: true
            // Layout.fillWidth: true
            source: "TerritoryMap.qml"
            //active: true
            //asynchronous: true
            visible: status == Loader.Ready
        }
        ColumnLayout {
            anchors.right: parent.right
            anchors.bottom: parent.bottom
            anchors.rightMargin: 10
            anchors.bottomMargin: 10
            visible: splitView.visible || !sidebar.visible

            // Sidebar open/close button
            RoundButton {
                id: showSidePanelButton
                Layout.alignment: Qt.AlignRight + Qt.AlignBottom
                Material.background: myPalette.window
                icon.source: sidebar.isVisible ? "qrc:/icons/view_sidebar_off.svg" : "qrc:/icons/view_sidebar.svg"
                icon.color: TBStyle.primaryTextColor
            }
        }
        BusyIndicator {
            id: _busyIndicator
            anchors.centerIn: parent
            running: territoryMapLoader.status === Loader.Loading
        }
    }

    Sidebar {
        id: sidebar
        Layout.fillWidth: true
        Layout.fillHeight: true

        hintText: qsTr("Select a territory on the left")
    }

    Item {
        id: itemView

        anchors.fill: parent
        visible: false

        Pane {
            anchors.fill: parent
            padding: 0
            spacing: 0
            visible: !sidebar.isVisible

            GridLayout {
                anchors.fill: parent
                LayoutItemProxy {
                    target: mapItem
                }
            }
        }
        Pane {
            anchors.fill: parent
            padding: 0
            spacing: 0

            visible: sidebar.isVisible

            GridLayout {
                anchors.fill: parent
                LayoutItemProxy {
                    target: sidebar
                }
            }
        }
    }

    SplitView {
        id: splitView

        anchors.fill: parent
        visible: true
        orientation: Qt.Horizontal

        Pane {
            SplitView.minimumWidth: root.width * 0.5
            SplitView.fillWidth: true
            padding: 0
            spacing: 0

            GridLayout {
                anchors.fill: parent
                LayoutItemProxy {
                    target: mapItem
                }
            }
        }

        Pane {
            implicitWidth: (root.width * 0.3) < 400 ? 400 : (root.width * 0.3)
            SplitView.minimumWidth: (root.width * 0.3) < 400 ? 400 : (root.width * 0.3)
            SplitView.maximumWidth: root.width * 0.5

            padding: 0
            spacing: 0

            visible: sidebar.isVisible

            GridLayout {
                anchors.fill: parent
                LayoutItemProxy {
                    target: sidebar
                }
            }
        }
    }
}
