import QtCore
import QtQuick
import QtQuick.Window
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase 1.0
import net.theocbase.mobile 1.0
import "."
import "sidePanelScripts.js" as SPScripts

SwipeDelegate {
    id: territoryAssignmentDelegate

    // PROPERTY DECLARATIONS
    property PersonsModel publisherListModel: assignmentModel.getPublisherList()
    property bool isPublisherLoading: true
    property bool isDateLoading: true

    // OBJECT PROPERTIES
    width: LookupControl.view.width
    hoverEnabled: LookupControl.view.hoverEnabled

    // CHILD OBJECTS
    TerritoryAssignmentValidator {
        id: publisherValidator
        model: territoryAssignmentDelegate.LookupControl.view.model.source
        assignmentId: id
        role: TerritoryAssignmentModel.PersonFullNameRole
        onErrorChanged: function(error) { publisherErrorLabel.text = error }
        onAssignmentIdChanged: {
            isPublisherLoading = true;
            isPublisherLoading = false;
        }
    }
    TerritoryAssignmentValidator {
        id: assignedDateValidator
        model: territoryAssignmentDelegate.LookupControl.view.model.source
        assignmentId: id
        role: TerritoryAssignmentModel.AssignedDateRole
        onErrorChanged: function(error) { assignedDateErrorLabel.text = error }
        onAssignmentIdChanged: {
            isDateLoading = true;
            isDateLoading = false;
        }
    }
    TerritoryAssignmentValidator {
        id: completedDateValidator
        model: territoryAssignmentDelegate.LookupControl.view.model.source
        assignmentId: id
        role: TerritoryAssignmentModel.CompletedDateRole
        onErrorChanged: function(error) { completedDateErrorLabel.text = error }
        onAssignmentIdChanged: {
            isDateLoading = true;
            isDateLoading = false;
        }
    }

    swipe.enabled: canEditTerritories
    swipe.right: Label {
        id: deleteLabel
        text: qsTr("Delete")
        color: "white"
        verticalAlignment: Label.AlignVCenter
        padding: 12
        height: parent.height
        anchors.right: parent.right

        SwipeDelegate.onClicked: assignmentModel.removeAssignment(id)

        background: Rectangle {
            color: deleteLabel.SwipeDelegate.pressed ? Qt.darker("tomato", 1.1) : "tomato"
        }
    }

    onClicked: territoryPanelStackView.push(assignmentDetailPage, { assignment: assignment })

    contentItem: Column {
        GridLayout {
            id: layout1
            width: parent.width
            columns: 3
            rows: 1

            Label {
                Layout.fillWidth: true
                Layout.alignment: Qt.AlignVCenter | Qt.AlignLeft
                horizontalAlignment: Text.AlignLeft
                text: personFullName
            }
            Item {
                Layout.alignment: Qt.AlignVCenter | Qt.AlignLeft
                implicitWidth: 100
                Label {
                    width: parent.width
                    anchors.verticalCenter: parent.verticalCenter
                    horizontalAlignment: Text.AlignRight
                    text: assignedDate.toLocaleDateString(Qt.locale(), Locale.ShortFormat)
                }
            }
            Item {
                Layout.alignment: Qt.AlignVCenter | Qt.AlignLeft
                implicitWidth: 100
                Label {
                    width: parent.width
                    anchors.verticalCenter: parent.verticalCenter
                    horizontalAlignment: Text.AlignRight
                    text: completedDate.toLocaleDateString(Qt.locale(), Locale.ShortFormat)
                }
            }
        }
        // validation texts
        Label {
            id: publisherErrorLabel
            font: TBStyle.bodySmallFont
            color: TBStyle.alertColor
            visible: text
        }
        Label {
            id: assignedDateErrorLabel
            font: TBStyle.bodySmallFont
            color: TBStyle.alertColor
            visible: text
        }
        Label {
            id: completedDateErrorLabel
            font: TBStyle.bodySmallFont
            color: TBStyle.alertColor
            visible: text
        }
    }
}
