import QtCore
import QtQuick
import QtQuick.Window
import QtQuick.Controls
import QtQuick.Layouts
import net.theocbase.mobile 1.0
import "."
import "sidePanelScripts.js" as SPScripts

SwipeDelegate {
    id: territoryAddressDelegate

    // PROPERTY DECLARATIONS
    property bool isValidationTextVisible: false
    property bool isStreetNameLoading: true
    property bool isAddressTypeLoading: true
    property bool isHouseNumberLoading: true
    property bool isNameLoading: true

    // SIGNAL DECLARATIONS

    // OBJECT PROPERTIES
    width: LookupControl.view.width
    height: delegateContent.implicitHeight + topPadding + bottomPadding
    highlighted: LookupControl.view.currentIndex === index
    hoverEnabled: LookupControl.view.hoverEnabled

    // CHILD OBJECTS
    TerritoryAddressValidator {
        id: streetNameValidator
        model: territoryAddressDelegate.LookupControl.view.model.source
        addressId: id
        role: TerritoryAddressModel.StreetRole
        onErrorChanged: function(error) { streetNameErrorLabel.text = error }
        onAddressIdChanged: {
            isValidationTextVisible = false;
            isStreetNameLoading = true;
            isStreetNameLoading = false;
        }
    }
    TerritoryAddressValidator {
        id: addressTypeValidator
        model: territoryAddressDelegate.LookupControl.view.model.source
        addressId: id
        role: TerritoryAddressModel.AddressTypeNumberRole
        onErrorChanged: function(error) { addressTypeErrorLabel.text = error }
        onAddressIdChanged: {
            isValidationTextVisible = false;
            isAddressTypeLoading = true;
            isAddressTypeLoading = false;
        }
    }
    TerritoryAddressValidator {
        id: houseNumberValidator
        model: territoryAddressDelegate.LookupControl.view.model.source
        addressId: id
        role: TerritoryAddressModel.HouseNumberRole
        onErrorChanged: function(error) { houseNumberErrorLabel.text = error }
        onAddressIdChanged: {
            isValidationTextVisible = false;
            isHouseNumberLoading = true;
            isHouseNumberLoading = false;
        }
    }
    TerritoryAddressValidator {
        id: nameValidator
        model: territoryAddressDelegate.LookupControl.view.model.source
        addressId: id
        role: TerritoryAddressModel.NameRole
        onErrorChanged: function(error) { nameErrorLabel.text = error }
        onAddressIdChanged: {
            isValidationTextVisible = false;
            isNameLoading = true;
            isNameLoading = false;
        }
    }
    Connections {
        target: territoryAddressDelegate.LookupControl.view.model.source
        function onModelChanged() {
            isValidationTextVisible = false;
        }
    }

    swipe.enabled: canEditTerritories
    swipe.right: Label {
        id: deleteLabel
        text: qsTr("Delete")
        color: "white"
        verticalAlignment: Label.AlignVCenter
        padding: 12
        height: parent.height
        anchors.right: parent.right

        SwipeDelegate.onClicked: territoryManager.mapView.removeAddress(id)

        background: Rectangle {
            color: deleteLabel.SwipeDelegate.pressed ? Qt.darker("tomato", 1.1) : "tomato"
        }
    }

    contentItem: Column {
        GridLayout {
            id: delegateContent
            width: parent.width
            columns: 2
            rows: 4

            Item {
                Layout.fillHeight: true
                Layout.columnSpan: 2
            }
            Label {
                Layout.fillWidth: true
                Layout.alignment: Qt.AlignVCenter | Qt.AlignLeft
                horizontalAlignment: Text.AlignLeft
                text: street
            }
            Item {
                Layout.alignment: Qt.AlignVCenter | Qt.AlignRight
                implicitWidth: 100
                Label {
                    width: parent.width
                    anchors.verticalCenter: parent.verticalCenter
                    horizontalAlignment: Text.AlignRight
                    text: addressTypeName
                }
            }
            Label {
                Layout.fillWidth: true
                Layout.alignment: Qt.AlignVCenter | Qt.AlignLeft
                horizontalAlignment: Text.AlignLeft
                text: houseNumber
            }
            Item {
                Layout.alignment: Qt.AlignVCenter | Qt.AlignRight
                implicitWidth: 100
                Label {
                    width: parent.width
                    anchors.verticalCenter: parent.verticalCenter
                    horizontalAlignment: Text.AlignRight
                    text: name
                }
            }
            Item {
                Layout.fillHeight: true
                Layout.columnSpan: 2
            }
        }
        // error labels
        Label {
            id: streetNameErrorLabel
            font: TBStyle.bodySmallFont
            color: TBStyle.alertColor
            visible: text
        }
        Label {
            id: addressTypeErrorLabel
            font: TBStyle.bodySmallFont
            color: TBStyle.alertColor
            visible: text
        }
        Label {
            id: houseNumberErrorLabel
            font: TBStyle.bodySmallFont
            color: TBStyle.alertColor
            visible: text
        }
        Label {
            id: nameErrorLabel
            font: TBStyle.bodySmallFont
            color: TBStyle.alertColor
            visible: text
        }
    }

    onClicked: {
        if (id > 0) {
            if (territoryManager.currentAddress?.id !== id) {
                territoryManager.currentAddress = addressModel.findAddress(id);
            } else {
                zoomSelectedAddress();
            }
        }
        LookupControl.view.currentIndex = index;
    }
}
