import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import net.theocbase.mobile 1.0

Rectangle {
    id: busypage
    width: 150
    height: 150
    color: "transparent"

    visible: false
    anchors.horizontalCenter: parent.horizontalCenter
    anchors.verticalCenter: parent.verticalCenter

    property string text: qsTr("Synchronizing...")

    function runSync()
    {
        busypage.text = busypage.text
        busypage.visible = true
        ccloud.synchronize(false);
    }

    function continueSync(keeplocal)
    {
        busypage.visible = true
        console.log("sync continued");
        ccloud.continueSynchronize(keeplocal);
    }

    function runTest()
    {
        busypage.visible = true;
        ccloud.runTest();
    }

    Connections {
        target: ccloud
        function onSyncProgressed(value, max) {
            console.log("progress bar value changed " + value + "/" + max);
        }
        function onSyncFinished() {
            console.log("sync ready");
            busypage.visible = false;
        }
    }

    BusyIndicator {
        id: busy

        anchors.verticalCenter: parent.verticalCenter
        anchors.horizontalCenter: parent.horizontalCenter

        anchors.centerIn: parent.Center        

        running: busypage.visible
    }

    Label {
        id: text1
        text: busypage.text
        horizontalAlignment: Text.AlignHCenter
        anchors.top: parent.top
        anchors.topMargin: 5
        anchors.horizontalCenter: parent.horizontalCenter
        renderType: Text.QtRendering
    }
}
