/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2019, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Layouts
import net.theocbase.mobile 1.0

Page {
    id: root

    property string pageTitle: qsTr("Selection List", "Page title")
    property alias model: list.model
    property alias selectedRow: list.currentIndex
    property bool showName: false

    signal activeRowChanged(int index)

    header: BaseToolbar {
        title: pageTitle
        componentLeft: ToolButton {
            icon.source: "qrc:/icons/back.svg"
            icon.color: Material.foreground
            onClicked: { stackView.pop() }
        }
    }

    ScrollView {
        width: parent.width
        height: parent.height
        contentWidth: width
        ListView {
            id: list
            width: root.width
            highlightFollowsCurrentItem: true

            onCurrentItemChanged: {
                root.activeRowChanged(currentIndex)
                console.log("Current item:" + currentIndex)
            }
            ButtonGroup {
                id: buttonGroup
            }
            delegate: RadioDelegate {
                text: showName ?
                          (typeof modelData === "undefined" ? (typeof name === "undefined" ? "-" : name) : model.modelData.name) :
                          model.modelData
                checked: list.currentIndex == index
                onClicked:{
                    console.log("clicked " + index)
                    if (checked)
                        list.currentIndex = index
                }
                width: root.width
                ButtonGroup.group: buttonGroup
            }
        }
    }
}

