import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Controls.Material.impl
import QtQuick.Layouts
import net.theocbase.mobile 1.0

Item {
    id: rowitem

    property string timeText: "11"
    property bool isTimeVisible: timeText !== ""
    property var timeColor: Material.foreground
    property string timeBackgroundColor: ""
    property int timePointSize: TBStyle.bodySmallFont.pointSize
    property string themeText
    property alias themeColor: textTheme.color
    property alias nameText1: textSpeaker
    property alias nameText2: textAssistant
    property string imageSource: ""
    property bool clickable: false

    signal clicked()

    AbstractButton {
        id: control

        anchors.fill: parent

        indicator: InterimIcon {
            x: control.mirrored ? control.leftPadding : control.width - width - control.rightPadding
            y: control.topPadding + (control.availableHeight - height) / 2
            source: rowitem.imageSource
            color: Material.foreground
        }

        contentItem: Control {
            height: Material.delegateHeight
            RowLayout {
                id: gridLayout1

                anchors.fill: parent
                anchors.leftMargin: !control.mirrored ? 0 : control.indicator.width + control.spacing
                anchors.rightMargin: control.mirrored ? 0 : control.indicator.width + control.spacing

                Rectangle {
                    id: item1

                    Layout.alignment: Qt.AlignVCenter
                    Layout.fillHeight: true
                    width: Material.delegateHeight
                    color: "transparent"

                    InfoBox {
                        anchors.verticalCenter: parent.verticalCenter
                        anchors.right: parent.right
                        rightPadding: 2
                        rightInset: 0
                        horizontalAlignment: Text.AlignRight
                        visible: rowitem.isTimeVisible
                        boxSize: InfoBox.BoxSize.Small
                        //: Material.delegateHeight
                        backgroundColor: rowitem.timeBackgroundColor
                        text: rowitem.timeText
                        textColor: rowitem.timeColor
                        pointSize: rowitem.timePointSize
                    }
                }

                Label {
                    id: textTheme
                    Layout.fillWidth: true
                    text: rowitem.themeText
                    elide: Text.ElideRight
                    wrapMode: Text.WordWrap
                    verticalAlignment: Text.AlignVCenter
                }

                ColumnLayout {
                    Layout.fillHeight: true
                    Layout.alignment: Qt.AlignVCenter
                    spacing: 0

                    Label {
                        id: textSpeaker
                        Layout.fillHeight: true
                        Layout.alignment: Qt.AlignRight | Qt.AlignVCenter
                        verticalAlignment: Text.AlignVCenter
                        text:  ""
                        visible: text !== ""
                        padding: 0
                        topInset: 0
                        bottomInset: 0
                    }
                    Label {
                        id: textAssistant
                        Layout.fillHeight: true
                        Layout.alignment: Qt.AlignRight | Qt.AlignVCenter
                        verticalAlignment: Text.AlignVCenter
                        text: ""
                        visible: text !== ""
                        padding: 0
                        topInset: 0
                        bottomInset: 0
                    }
                }
            }
        }

        background: Rectangle {
            implicitHeight: control.Material.delegateHeight

            color: control.highlighted ? control.Material.listHighlightColor : "transparent"

            Ripple {
                width: parent.width
                height: parent.height

                clip: visible
                pressed: control.pressed
                anchor: control
                active: enabled && (control.down || control.visualFocus || control.hovered)
                color: control.Material.rippleColor
            }
        }

        onClicked: {
            if (rowitem.clickable) {
                rowitem.clicked();
            }
        }
    }
}
