import QtQuick
import QtQuick.Controls
import QtQuick.Controls.impl
import QtQuick.Controls.Material
import QtQuick.Layouts
import net.theocbase.mobile 1.0
import "./"

ItemDelegate {
    id: control

    property string title: ""
    property bool arrow: false
    property bool editable: false
    property alias inputMethodHints: textField.inputMethodHints
    property bool strikeout: false

    implicitWidth: Math.max(implicitBackgroundWidth + leftInset + rightInset,
                            implicitContentWidth + leftPadding + rightPadding)
    implicitHeight: Math.max(implicitBackgroundHeight + topInset + bottomInset,
                             implicitContentHeight + topPadding + bottomPadding,
                             implicitIndicatorHeight + topPadding + bottomPadding)

    padding: 16
    verticalPadding: Material.textFieldVerticalPadding
    spacing: 16

    icon.width: 24
    icon.height: 24
    icon.color: enabled ? Material.foreground : Material.hintTextColor

    signal editingFinished()

    onClicked: {
        console.log("row click")
        if (editable && mouse.x >= textField.x){
            mouse.accepted = false
            textField.forceActiveFocus()
        }else{
            control.focus = true
        }
    }
    onPressAndHold: {
        control.forceActiveFocus()
    }

    SystemPalette {
        id: palette
    }
    SystemPalette {
        id: paletteDisabled
        colorGroup: SystemPalette.Disabled
    }

    indicator: RowLayout {
        x: control.width / 2 - control.rightPadding
        y: control.topPadding + control.availableHeight / 2 - height / 2
        width: control.width / 2

        Label {
            id: textvalue
            Layout.fillWidth: true
            visible: !editable
            text: control.text
            //font: control.font
            color: paletteDisabled.text
            horizontalAlignment: Text.AlignRight
            verticalAlignment: Text.AlignVCenter
            wrapMode: Text.WordWrap
            font.strikeout: control.strikeout
        }
        TextField {
            id: textField
            Layout.fillWidth: true
            visible: editable
            Material.containerStyle: Material.Filled
            text: control.text
            horizontalAlignment: Text.AlignRight
            verticalAlignment: Text.AlignVCenter
            onTextEdited: control.text = text
            onEditingFinished: control.editingFinished()
        }
        InterimIcon {
            visible: arrow
            source: "qrc:/icons/chevron_right.svg"
            Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
        }
    }

    contentItem: IconLabel {
        leftPadding: !control.mirrored ? 0 : control.indicator.width + control.spacing
        rightPadding: control.mirrored ? 0 : control.indicator.width + control.spacing

        spacing: control.spacing
        mirrored: control.mirrored
        display: control.display
        alignment: control.display === IconLabel.IconOnly || control.display === IconLabel.TextUnderIcon ? Qt.AlignCenter : Qt.AlignLeft

        icon: control.icon
        text: control.title
        font: control.font
        color: control.enabled ? control.Material.foreground : control.Material.hintTextColor
    }
}
