/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2019, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Layouts
import net.theocbase.mobile 1.0
import "./"

Page {
    id: weekendMeetingEdit

    property CPTMeeting meeting

    title: qsTr("Public Talk", "Page title")
    onMeetingChanged: {
        if (meeting)
            controller.date = meeting.date
    }

    PublicMeetingController { id: controller }

    header: BaseToolbar {
        title: weekendMeetingEdit.title
        componentLeft: ToolButton {
            icon.source: "qrc:/icons/back.svg"
            onClicked: {
                stackView.pop()
            }
        }
    }

    ScrollView {
        width: parent.width
        height:parent.height
        contentWidth: width
        //clip: true

        Pane {
            width: weekendMeetingEdit.availableWidth
            ColumnLayout {
                id: layout
                width: parent.width
                spacing: 16

                // Congregations
                FilledGroupBox {
                    id: congregationGroupBox
                    Layout.fillWidth: true
                    title: qsTr("Congregation")

                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                            source: "qrc:/icons/home_congregation.svg"
                            color: Material.foreground
                        }
                        ComboBoxTable {
                            id: comboCongregation
                            Layout.fillWidth: true
                            currentText: meeting.speaker ? meeting.speaker.congregationName : ""
                            col1Name: congregationGroupBox.title
                            onBeforeMenuShown: {
                                model = controller.congregationList()
                                //column2.resizeToContents()
                            }
                            onRowSelected: {
                                console.log(id)
                                //myMeeting.setTheme(id)
                            }
                        }
                    }
                }
                // Speaker
                FilledGroupBox {
                    id: speakerGroupBox
                    Layout.fillWidth: true
                    title: qsTr("Speaker")

                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                            source: "qrc:/icons/speaker.svg"
                            color: Material.foreground
                        }
                        ComboBoxTable {
                            id: comboSpeaker
                            Layout.fillWidth: true
                            currentText: meeting.speaker ? meeting.speaker.fullName : ""
                            currentId: meeting.speaker ? meeting.speaker.id : -1
                            col1Name: speakerGroupBox.title
                            onBeforeMenuShown: {
                                var congregationId = 0
                                if (comboCongregation.currentText != "") {
                                    if (typeof(comboCongregation.model) === "undefined")
                                        comboCongregation.model = controller.congregationList()
                                    congregationId = comboCongregation.model.get(comboCongregation.model.find(comboCongregation.currentText,2)).id
                                }
                                var talkId = 0
                                if (comboTheme.currentText != "") {
                                    if (typeof (comboTheme.model) === "undefined")
                                        comboTheme.model = controller.themeList(0)
                                    talkId = comboTheme.model.get(comboTheme.model.find(meeting.themeNumber + " " + meeting.theme,2)).id
                                }
                                model = controller.speakerList(talkId, congregationId)
                                //column2.resizeToContents()
                            }
                            onRowSelected: {
                                console.log(id)
                                var speaker = CPersons.getPerson(id)
                                meeting.speaker = speaker
                                meeting.save()
                            }
                        }
                    }
                }
                // Theme
                FilledGroupBox {
                    id: themeGroupBox
                    Layout.fillWidth: true
                    title: qsTr("Theme")

                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                            source: "qrc:/icons/title.svg"
                            color: Material.foreground
                        }
                        ComboBoxTable {
                            id: comboTheme
                            Layout.fillWidth: true
                            currentText: (meeting.themeNumber > 0 ? meeting.themeNumber + " " : "") + meeting.theme
                            col1Name: themeGroupBox.title
                            onBeforeMenuShown: {
                                model = controller.themeList(meeting.speaker ? meeting.speaker.id : 0)
                                console.log("model loaded")
                                //column2.resizeToContents()
                                //console.log("col2 resized")
                            }
                            onRowSelected: {
                                console.log(id)
                                meeting.setTheme(id)
                                meeting.save()
                            }
                        }
                    }
                }
                // Contact information
                FilledGroupBox {
                    Layout.fillWidth: true
                    title: qsTr("Contact Information")

                    Column {
                        width: parent.width
                        RowLayout {
                            width: parent.width
                            InterimIcon {
                                Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                                source: "qrc:/icons/smartphone.svg"
                                color: Material.foreground
                            }
                            TextField {
                                Layout.fillWidth: true
                                Material.containerStyle: Material.Filled
                                selectByMouse: true
                                wrapMode: Text.WordWrap
                                text: meeting.speaker ? meeting.speaker.mobile : ""
                                enabled: meeting.speaker
                                onEditingFinished: {
                                    if (meeting.speaker) {
                                        meeting.speaker.mobile = text
                                        meeting.speaker.save()
                                    }
                                }
                            }
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowLayout {
                            width: parent.width
                            InterimIcon {
                                Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                                source: "qrc:/icons/call.svg"
                                color: Material.foreground
                            }
                            TextField {
                                Layout.fillWidth: true
                                Material.containerStyle: Material.Filled
                                selectByMouse: true
                                wrapMode: Text.WordWrap
                                text: meeting.speaker ? meeting.speaker.phone : ""
                                enabled: meeting.speaker
                                onEditingFinished: {
                                    if (meeting.speaker) {
                                        meeting.speaker.phone = text
                                        meeting.speaker.save()
                                    }
                                }
                            }
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowLayout {
                            width: parent.width
                            InterimIcon {
                                Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                                source: "qrc:/icons/mail.svg"
                                color: Material.foreground
                            }
                            TextField {
                                Layout.fillWidth: true
                                Material.containerStyle: Material.Filled
                                selectByMouse: true
                                wrapMode: Text.WordWrap
                                text: meeting.speaker ? meeting.speaker.email : ""
                                enabled: meeting.speaker
                                onEditingFinished: {
                                    if (meeting.speaker) {
                                        meeting.speaker.email = text
                                        meeting.speaker.save()
                                    }
                                }
                            }
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowLayout {
                            width: parent.width
                            InterimIcon {
                                Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                                source: "qrc:/icons/info.svg"
                                color: Material.foreground
                            }
                            TextArea {
                                Layout.fillWidth: true
                                Material.containerStyle: Material.Filled
                                selectByMouse: true
                                wrapMode: Text.WordWrap
                                text: meeting.speaker ? meeting.speaker.info : ""
                                enabled: meeting.speaker
                                onEditingFinished: {
                                    if (meeting.speaker) {
                                        meeting.speaker.info = text
                                        meeting.speaker.save()
                                    }
                                }
                            }
                        }
                    }
                }
                // Hospitality
                FilledGroupBox {
                    id: hostGroupBox
                    Layout.fillWidth: true
                    title: qsTr("Host")

                    RowLayout {
                        width: parent.width
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignVCenter
                            source: "qrc:/icons/hospitality.svg"
                            color: Material.foreground
                        }
                        ComboBoxTable {
                            id: comboHost
                            Layout.fillWidth: true
                            col1Name: hostGroupBox.title
                            currentText: meeting.hospitalityHost ? meeting.hospitalityHost.fullName : ""
                            currentId: meeting.hospitalityHost ? meeting.hospitalityHost.id : -1
                            onBeforeMenuShown: {
                                model = controller.hospitalityList();
                                var congregationId = 0
                            }
                            onRowSelected: {
                                meeting.hospitalityHost = CPersons.getPerson(id)
                                meeting.save()
                            }
                        }
                    }
                }
            }
        }
    }
}
