import QtQuick

Item {
    property alias menuContent: loaderItem.sourceComponent
    id: popUpPage
    visible: false

    function show(x, y){
        myRect.x = x - myRect.width/2
        myRect.y = y - myRect.height - 10
        if ((myRect.x + myRect.width + 10) > width){
            myRect.x = width - myRect.width - 10
        }else if((myRect.x < 10)){
            myRect.x = 10
        }
        visible = true
    }

    anchors.fill: parent
    Rectangle {
        opacity: 0.2
        color: "grey"
        z: -1
        anchors.fill: parent
        MouseArea {
            anchors.fill: parent
            onClicked: popUpPage.visible = false
        }
    }
    Rectangle {
        id: myRect
        implicitWidth: loaderItem.item === "undefined" ? 50 : loaderItem.item.implicitWidth + 10
        height: 45
        radius: 10
        opacity: 1
        color: "#30496F"

        Loader {
            id: loaderItem
            z: 2
            anchors.fill: parent
            anchors.rightMargin: 5
            anchors.leftMargin: 5
        }
        MouseArea {
            anchors.fill: parent
            onClicked: popUpPage.visible = false
        }
    }
    Rectangle {
        x: myRect.x+myRect.width / 2
        y: myRect.y+myRect.height - 5
        width: 15; height: 15
        rotation: -45
        transformOrigin: Item.BottomLeft
        color: "#30496F"
    }
}

