import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Layouts
import net.theocbase.mobile 1.0

Pane {
    id: outgoingSpeakersModule

    property date currentDate

    padding: 0
    Material.background: TBStyle.outgoingSpeakersColor

    function loadList(d) {
        currentDate = d
        outModel.loadList(currentDate)
    }

    OutgoingSpeakersModel {
        id: outModel
    }

    Column {
        id: layout
        width: parent.width
        spacing: 0

        RowLayout {
            width: parent.width
            height: Material.delegateHeight
            Rectangle {
                color: TBStyle.outgoingSpeakersTextColor
                height: Material.delegateHeight
                width: Material.delegateHeight
                InterimIcon {
                    id: osIcon
                    anchors.fill: parent
                    anchors.margins: 4
                    source: "qrc:/icons/location_away_48dp.svg"
                    color: Material.background
                }
            }
            Label {
                id: text5
                Layout.fillWidth: true
                text: qsTr("Outgoing speakers")
                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignLeft
                font: TBStyle.titleLargeFont
                color: TBStyle.outgoingSpeakersTextColor
            }
        }
        ListView {
            width: parent.width
            implicitHeight: childrenRect.height
            model: outModel
            interactive: false
            delegate: ScheduleRowItem {
                height: Material.delegateHeight
                width: lmmListView.width
                timeText: Qt.locale().dayName(date.getDay(), Locale.ShortFormat)
                timeBackgroundColor: TBStyle.outgoingSpeakersTextColor
                themeText: theme == "" ? "" : theme + " (" + themeNo + ")"
                nameText1.text: speaker
                nameText2.text: "(" + congregation + ")"
            }
        }
        ScheduleRowItem {
            width: parent.width
            height: Material.delegateHeight
            timeBackgroundColor: "transparent"
            timeText: ""            
            themeText: outModel.length > 0 ?
                                qsTr("%1 speakers away this weekend","", outModel.length).arg(outModel.length) :
                                qsTr("No speakers away this weekend")
            themeColor: TBStyle.mediumColor
        }
    }
}
