/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2019, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Layouts
import QtQuick.Window
import net.theocbase.mobile 1.0

Item {
    property alias navigation: stackViewRoot
    property alias detail: stackViewDetail
    property bool useSplitView: width > 600 && stackViewDetail.depth > 0
    property Item currentDetailitem

    function pop(args) {
        var item = arguments[0];
        var operation = arguments[1];
        if (stackViewDetail.depth === 1)
            stackViewDetail.clear(StackView.PopTransition);
        else
            return stackViewDetail.pop(item, operation);
    }
    function clearAndPush(args) {
        var item = arguments[0];
        var properties = arguments[1];
        var operation = arguments[2];
        stackViewDetail.clear(StackView.Immediate);
        return push(item, properties, operation);
    }
    function push(args) {
        var item = arguments[0];
        var properties = arguments[1];
        var operation = arguments[2];
        if (stackViewDetail.depth === 0 && operation === undefined)
            operation = StackView.PushTransition;
        return stackViewDetail.push(item, properties, operation);
    }
    function replace(args) {
        var target = arguments[0];
        var item = arguments[1];
        var properties = arguments[2];
        var operation = arguments[3];
        return stackViewDetail.replace(target, item, properties, operation);
    }
    function updateLayout() {
        if (useSplitView) {
            singleLayout.visible = false;
            splitLayout.visible = true;
        } else {
            singleLayout.visible = true;
            splitLayout.visible = false;
        }
    }

    onUseSplitViewChanged: {
        updateLayout();
    }

    onWidthChanged: {
        if (Qt.platform.os === "ios") {
            IOSUtil.orientationChanged(Screen.orientation)
        }
        updateLayout();
    }
    onHeightChanged: {
        updateLayout();
    }

    StackView {        
        id: stackViewRoot

        Layout.fillHeight: true
        Layout.fillWidth: true
        // clip: true
        onCurrentItemChanged: {
            stackViewDetail.clear(StackView.Immediate);
            updateLayout();
        }               
    }

    StackView {
        id: stackViewDetail

        Layout.fillHeight: true
        Layout.fillWidth: true

        onCurrentItemChanged: {
            currentDetailitem = currentItem;
            updateLayout();
        }
        //clip: true
        pushEnter: Transition {
            XAnimator {
                from: stackViewDetail.width
                to: 0
                duration: 500
                easing.type: Easing.OutCubic
            }
        }
        pushExit: Transition {
            XAnimator {
                duration: 500
                easing.type: Easing.OutCubic
            }
        }
        popEnter: Transition {
            XAnimator {
                duration: 500
                easing.type: Easing.OutCubic
            }
        }
        popExit: Transition {
            XAnimator {
                from: 0
                to: stackViewDetail.width
                duration: 500
                easing.type: Easing.OutCubic
            }
        }
    }

    Pane {
        id: singleLayout
        anchors.fill: parent
        padding: 0
        visible: false
        GridLayout {
            anchors.fill: parent
            LayoutItemProxy { target: stackViewRoot }
        }
        GridLayout {
            anchors.fill: parent
            visible: stackViewDetail.depth > 0
            LayoutItemProxy { target: stackViewDetail }
        }
    }

    GridLayout {
        id: splitLayout
        anchors.fill: parent
        columns: 2
        visible: true
        LayoutItemProxy { target: stackViewRoot }
        LayoutItemProxy { target: stackViewDetail }
    }
}
