/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2021, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Layouts
import QtQuick.Window
import net.theocbase.mobile 1.0
import "./"

Page {
    property string pageTitle: ""
    property var meeting
    property bool editable: false

    header: BaseToolbar {
        title: pageTitle
        componentLeft: ToolButton {
            icon.source: "qrc:/icons/back.svg"
            onClicked: {
                stackView.pop()
            }
        }
    }

    ScrollView {
        id: flickable
        anchors.fill: parent
        contentWidth: availableWidth

        Pane {
            width: parent.width
            ColumnLayout {
                id: layout
                width: parent.width
                spacing: 16

                FilledGroupBox {
                    Layout.fillWidth: true
                    Layout.minimumHeight: 100
                    title: qsTr("Notes", "Meeting Notes")

                    RowLayout {
                        anchors.fill: parent
                        InterimIcon {
                            Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                            source: "qrc:/icons/notes.svg"
                            color: Material.foreground
                            ToolTip.text: qsTr("Notes")
                            ToolTip.visible: hovered
                        }
                        TextArea {
                            id: textAreaNotes
                            Layout.fillWidth: true
                            Layout.fillHeight: true
                            Material.containerStyle: Material.Filled
                            text: meeting ? meeting.notes : ""
                            wrapMode: Text.WordWrap
                            readOnly: !editable
                            onEditingFinished: {
                                if (meeting.notes !== text) {
                                    meeting.notes = text
                                    meeting.saveNotes()
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
