import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Layouts
import net.theocbase.mobile 1.0

Pane {
    property string bibleReading
    property int length: lmmListView.model ? lmmListView.model.length : 0
    property var t
    property bool showTime: false
    property int looptest: 0
    property bool noMultiSchool: myMeeting.date.getFullYear() < 2018 && myMeeting.date.getDate() < 8
    property bool editpossible: true

    function formatTime(time) {
        var newTime = Qt.formatTime(time, Qt.DefaultLocaleShortDate);
        var regex = /^(2[0-3]|[0-1]?[\d]):[0-5][\d]/;
        var found = newTime.match(regex);
        if (found !== null)
            newTime = found[0];
        return newTime;
    }

    function loadSchedule(currentdate){
        showTime = settings_ui.showTime

        // load meeting data
        myMeeting.loadMeeting(currentdate)

        // song beginning
        t = myMeeting.startTime
        songBeginningRow.timeText = showTime ? formatTime(t) : "\u266B"
        t.setMinutes(t.getMinutes()+5)

        // opening comments
        var ocTime = myMeeting.date.getFullYear() < 2020 ? 3 : 1
        openingCommentsRow.timeText = showTime ? formatTime(t) : ocTime.toString()
        t.setMinutes(t.getMinutes()+ocTime)

        // assignments
        lmmListView.model = myMeeting.getAssignmentsVariant()

        // service talk
        coServiceTalkRow.visible = false
        for(var i = 0; i < lmmListView.model.length; i++){
            if (lmmListView.model[i].meetingPart === MeetingPart.Service_Talk){
                coServiceTalkRow.visible = true
                coServiceTalkRow.themeText = lmmListView.model[i].theme
                coServiceTalkRow.nameText1.text = lmmListView.model[i].speakerFullName
            }
        }

        var t2 = new Date(myMeeting.startTime)
        t2.setMinutes(t2.getMinutes()+(coServiceTalkRow.visible ? 67 : 97))

        // concluding comments
        reviewCommentsRow.timeText = showTime ? formatTime(t2) : "3"
        t2.setMinutes(t2.getMinutes()+3)

        // co service talk (it is after review comments)
        if (coServiceTalkRow.visible){
            coServiceTalkRow.timeText = showTime ? formatTime(t2) : 30
            t2.setMinutes(t2.getMinutes()+30)
        }

        // song end
        songEndRow.timeText = showTime ? formatTime(t2) : "\u266B"

        // bible reading
        bibleReading = myMeeting.bibleReading
    }

    function editButtonClicked(index, replacepage){
        var assignment = lmmListView.model[index]
        if (replacepage === "undefined")
            replacepage = false

        var dialogType = ""
        var meetingPart = assignment.meetingPart
        switch(meetingPart){
        case MeetingPart.LMM_TR_BibleReading:
        case MeetingPart.LMM_FM_StartingConversation:
        case MeetingPart.LMM_FM_FollowingUp:
        case MeetingPart.LMM_FM_MakingDisciples:
        case MeetingPart.LMM_FM_Talk:
        case MeetingPart.LMM_FM_BeliefsTalk:
        case MeetingPart.LMM_FM_BeliefsDemonstration:
        case MeetingPart.LMM_MemorialInvitation:
            dialogType = "LMMStudentAssignmentDialog.qml";
            break;
        default:
            dialogType =  "LMMAssignmentDialog.qml";
            break;
        }
        var detailsPage
        if (replacepage) {
            detailsPage = stackView.replace(replacepage, Qt.resolvedUrl(dialogType),
                                            {currentAssignment: assignment, currentindex: index, modelLength: length},
                                            StackView.Immediate)
        } else {
            stackView.pop(null)
            detailsPage = stackView.clearAndPush(Qt.resolvedUrl(dialogType),
                                                 {currentAssignment: assignment, currentindex: index, modelLength: length})
        }
        detailsPage.onGotoNext.connect(function(){editButtonClicked(index+1,true)})
        detailsPage.onGotoPrevious.connect(function(){editButtonClicked(index-1,true)})
    }

    function getAssignmentByIndex(index){
        return lmmListView.model[index]
    }

    function getIconSource(index){
        switch(index){
        case MeetingSection.TreasuresFromGodsWord: return "qrc:/icons/lmm_gw_48dp.svg"
        case MeetingSection.ApplyYourselfToTheFieldMinistry: return "qrc:/icons/lmm_fm_48dp.svg"
        case MeetingSection.LivingAsChristians: return "qrc:/icons/lmm_cl_48dp.svg"
        default: return ""
        }
    }

    padding: 0

    LMM_Meeting{
        id: myMeeting
        function updateOnCounselorChange() {
            lmmListView.model = myMeeting.getAssignmentsVariant()
        }
        onCounselor2Changed: updateOnCounselorChange()
        onCounselor3Changed: updateOnCounselorChange()
    }
    AssignmentController { id: myController }

    Column {
        id: layout
        width: parent.width
        spacing: 0

        RowLayout {
            width: parent.width
            height: Material.delegateHeight
            Label {
                Layout.fillWidth: true
                Layout.leftMargin: 5
                Layout.alignment: Qt.AlignVCenter
                verticalAlignment: Text.AlignVCenter
                text: "●●○ " + Qt.locale().dayName(mwDate.getDay(), Locale.LongFormat) +
                      " | " + qsTr("Midweek Meeting").toUpperCase()
                elide: Text.ElideRight
                font: TBStyle.titleMediumFont
                color: TBStyle.primaryTextColor
            }
            ToolButton {
                icon.source: "qrc:/icons/wol.svg"
                icon.color: TBStyle.primaryTextColor
                visible: canEditMidweekMeetingSchedule && editpossible
                onClicked: {
                    stackView.clearAndPush(Qt.resolvedUrl("WebBrowser.qml"), { "date" : myMeeting.date, "meetingType" : MeetingType.MidweekMeeting })
                }
            }
            ToolButton {
                icon.source: myMeeting.notes ? "qrc:/icons/notes.svg" : "qrc:/icons/add_notes.svg"
                icon.color: TBStyle.primaryTextColor
                visible: canViewMeetingNotes && editpossible
                onClicked: {
                    stackView.clearAndPush(Qt.resolvedUrl("MeetingNotes.qml"),
                                           { "pageTitle": qsTr("Midweek Meeting"), "meeting": myMeeting, "editable": canEditMeetingNotes })
                }
            }
        }
        ScheduleRowItem {
            id: importText
            timeText: ""
            width: parent.width
            height: Material.delegateHeight
            visible: length == 0 && editpossible && canEditMidweekMeetingSchedule
            Label {
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.verticalCenter: parent.verticalCenter
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter                
                text: qsTr("<html><a href='#'>" + qsTr("Import Schedule...") + "</a></html>")
                onLinkActivated: {
                    console.log("Import schedule link clicked!")
                    shareUtils.openFile("epub")
                }                
            }
        }

        TabBar {
            id: tabView
            property int classqty: myMeeting.classes
            width: parent.width
            visible: classqty > 1

            Repeater {
                model: tabView.classqty
                TabButton {
                    Material.accent: TBStyle.primaryTextColor
                    text: modelData == 0 ? qsTr("MH","abbreviation for main hall") :
                                           modelData == 1 ? qsTr("A1", "abbreviation for auxiliary classroom 1") :
                                                            qsTr("A2", "abbreviation for auxiliary classroom 2")
                }
            }
        }
        Item {
            id: chairmanRow
            width: parent.width
            height: Material.delegateHeight
            visible: length > 0

            RowLayout {
                anchors.fill: parent
                Label {
                    id: chairmanLabel
                    Layout.fillWidth: true
                    text: tabView.currentIndex === 0 ? qsTr("Chairman") : qsTr("Counselor")
                    color: TBStyle.mediumColor
                }
                Label {
                    Layout.fillWidth: true
                    horizontalAlignment: Text.AlignRight
                    text: tabView.currentIndex === 0
                          ? (myMeeting.chairman ? myMeeting.chairman.fullName : "")
                          : tabView.currentIndex === 1
                            ? (myMeeting.counselor2 ? myMeeting.counselor2.fullName : "")
                            : (myMeeting.counselor3 ? myMeeting.counselor3.fullName : "")
                }
                InterimIcon {
                    Layout.rowSpan: 2
                    source: listRowMouseArea.enabled ? "qrc:/icons/chevron_right.svg" : ""
                    color: TBStyle.onPrimaryColor
                }
            }
            Rectangle {
                anchors.fill: parent
                color: "grey"
                opacity: listRowMouseArea.pressed ? 0.1 : 0
                MouseArea {
                    anchors.fill: parent
                    id: listRowMouseArea
                    enabled: canEditMidweekMeetingSchedule && editpossible
                    onClicked: {
                        var mylist = myMeeting.getChairmanList()
                        var rowindex;
                        switch (tabView.currentIndex)
                        {
                        case 0: rowindex = myMeeting.chairman ? mylist.find(myMeeting.chairman.id,1) : -1; break
                        case 1: rowindex = myMeeting.counselor2 ? mylist.find(myMeeting.counselor2.id,1) : -1; break
                        case 2: rowindex = myMeeting.counselor3 ? mylist.find(myMeeting.counselor3.id,1) : -1; break
                        }
                        var chairmanPage = stackView.clearAndPush(Qt.resolvedUrl("SelectionListPage.qml"),
                                                                  {showName: true, model: mylist, selectedRow: rowindex, pageTitle: chairmanLabel})
                        chairmanPage.onActiveRowChanged.connect(function(index){
                            var p = (typeof mylist.get(index).id === "undefined") ? null : myController.getPublisherById(mylist.get(index).id)
                            switch (tabView.currentIndex){
                            case 0: myMeeting.chairman = p; break
                            case 1: myMeeting.counselor2 = p; break
                            case 2: myMeeting.counselor3 = p; break
                            }
                            // video without discussion
                            var video = myMeeting.getAssignment(MeetingPart.LMM_CL_Video, 0, tabView.currentIndex + 1)
                            if (video !== null) {
                                video.speaker = b
                                video.save()
                            }
                            myMeeting.save()
                        })
                    }
                }
            }
        }

        ScheduleRowItem {
            id: songBeginningRow
            width: parent.width
            height: Material.delegateHeight
            visible: length > 0
            themeText: qsTr("Song %1 and Prayer").arg(myMeeting.songBeginning.toString()) +
                            (settings_ui.showSongTitles ? "\n" + myMeeting.songBeginningTitle : "")
            themeColor: TBStyle.mediumColor
            timeColor: showTime ? Material.background : TBStyle.lmmSection1TextColor
            timeBackgroundColor: showTime ? TBStyle.lmmSection1TextColor : "transparent"
            nameText1.text: myMeeting.prayerBeginning ? myMeeting.prayerBeginning.fullName : ""            
            imageSource: clickable ? "qrc:/icons/chevron_right.svg" : ""
            clickable: canEditMidweekMeetingSchedule && editpossible
            onClicked: {
                var mylist = myMeeting.getPrayerList()
                var rowindex = myMeeting.prayerBeginning ? mylist.find(myMeeting.prayerBeginning.id,1) : -1
                var speakersPage = stackView.clearAndPush(Qt.resolvedUrl("SelectionListPage.qml"),
                                                          {showName: true, model: mylist, selectedRow: rowindex, pageTitle: qsTr("Prayer")})
                speakersPage.onActiveRowChanged.connect(function(index){
                    myMeeting.prayerBeginning = (typeof mylist.get(index).id === "undefined") ? null : myController.getPublisherById(mylist.get(index).id)
                    myMeeting.save()
                })
            }
        }

        ScheduleRowItem {
            id: openingCommentsRow
            width: parent.width
            height: Material.delegateHeight
            themeText: qsTr("Opening Comments")
            themeColor: TBStyle.mediumColor
            timeColor: Material.background
            timeBackgroundColor: TBStyle.lmmSection1TextColor
            visible: lmmListView.model.length > 0
            imageSource: clickable ? "qrc:/icons/chevron_right.svg" : ""
            clickable: canEditMidweekMeetingSchedule && editpossible
            onClicked: {
                var notePage = stackView.clearAndPush(Qt.resolvedUrl("LMMNotesDialog.qml"),
                                                      {pageTitle: themeText, notes : myMeeting.openingComments})
                notePage.onSaveChanges.connect(function(notes){
                    if (myMeeting.openingComments !== notes) {
                        myMeeting.openingComments = notes
                        myMeeting.save()
                    }
                })
            }
        }

        ListView {
            id: lmmListView
            width: parent.width
            implicitHeight: childrenRect.height
            delegate: listRow
            interactive: false
        }
        ScheduleRowItem {
            id: reviewCommentsRow
            width: parent.width
            height: Material.delegateHeight
            themeText: qsTr("Concluding Comments")
            themeColor: TBStyle.mediumColor
            timeColor: Material.background
            timeBackgroundColor: TBStyle.lmmSection3TextColor
            visible: lmmListView.model.length > 0
            imageSource: clickable ? "qrc:/icons/chevron_right.svg" : ""
            clickable: canEditMidweekMeetingSchedule && editpossible
            onClicked: {
                var notePage = stackView.clearAndPush(Qt.resolvedUrl("LMMNotesDialog.qml"),
                                                      {pageTitle: themeText, notes : myMeeting.closingComments})
                notePage.onSaveChanges.connect(function(notes){
                    if (myMeeting.closingComments !== notes) {
                        myMeeting.closingComments = notes
                        myMeeting.save()
                    }
                })
            }
        }
        ScheduleRowItem {
            id: coServiceTalkRow
            width: parent.width
            height: Material.delegateHeight
            visible: false
            timeColor: Material.background
            timeBackgroundColor: Material.foreground
        }

        ScheduleRowItem {
            id: songEndRow
            width: parent.width
            height: Material.delegateHeight
            visible: length > 0
            themeText: qsTr("Song %1 and Prayer").arg(myMeeting.songEnd.toString()) +
                            (settings_ui.showSongTitles ? "\n" + myMeeting.songEndTitle : "")
            themeColor: TBStyle.mediumColor
            timeColor: showTime ? Material.background : TBStyle.lmmSection3TextColor
            timeBackgroundColor: showTime ? TBStyle.lmmSection3TextColor : "transparent"
            nameText1.text: myMeeting.prayerEnd ? myMeeting.prayerEnd.fullName : ""
            imageSource: clickable ? "qrc:/icons/chevron_right.svg" : ""
            clickable: canEditMidweekMeetingSchedule && editpossible
            onClicked: {
                var mylist = myMeeting.getPrayerList()
                var rowindex = myMeeting.prayerEnd ? mylist.find(myMeeting.prayerEnd.id,1) : -1
                var speakersPage = stackView.clearAndPush(Qt.resolvedUrl("SelectionListPage.qml"),
                                                          {showName: true, model: mylist, selectedRow: rowindex, pageTitle: qsTr("Prayer")})
                speakersPage.onActiveRowChanged.connect(function(index){
                    myMeeting.prayerEnd = (typeof mylist.get(index).id === "undefined") ? null : myController.getPublisherById(mylist.get(index).id)
                    myMeeting.save()
                })
            }
        }
    }
    Component {
        id: listRow
        Rectangle {
            id: headerBackground

            property bool hdr: typeof model.modelData.assignmentInfo === "undefined"
                               ? false
                               : (model.modelData.meetingPart === MeetingPart.LMM_TR_Talk
                                  || (index > 0 && model.modelData.assignmentInfo.meetingSection !== lmmListView.model[index - model.modelData.classnumber].assignmentInfo.meetingSection))
            property string hdr_text_color: model.modelData.meetingPart === MeetingPart.Service_Talk
                                            ? Material.foreground
                                            : model.modelData.assignmentInfo.meetingSectionTextColor
            property bool isVisible: (!model.modelData.canMultiSchool || tabView.currentIndex + 1 === model.modelData.classnumber) &&
                                     model.modelData.meetingPart !== MeetingPart.Service_Talk

            visible: isVisible
            implicitHeight: childrenRect.height
            height: isVisible ? implicitHeight : 0
            width: lmmListView.width
            color: model.modelData.meetingPart === MeetingPart.Service_Talk
                   ? "transparent"
                   : model.modelData.assignmentInfo.meetingSectionColor

            Component.onCompleted: {
                rowIcon.source = getIconSource(model.modelData.assignmentInfo.meetingSection);
                headerText.text = model.modelData.assignmentInfo.meetingSectionName;
                // time
                if (model.modelData.meetingPart === MeetingPart.LMM_TR_BibleReading && model.modelData.classnumber === 1){
                    t.setMinutes(t.getMinutes() + 1);
                } else if (model.modelData.assignmentInfo.meetingSection === MeetingSection.LivingAsChristians
                           && model.modelData.assignmentInfo.meetingSection !== lmmListView.model[index - model.modelData.classnumber].assignmentInfo.meetingSection){
                    t = new Date(myMeeting.startTime);
                    t.setMinutes(t.getMinutes() + 47);
                    songRow.timeText = showTime ? formatTime(t) : "\u266B";
                    t.setMinutes(t.getMinutes() + 5);
                }
                themeRow.timeText = showTime ? formatTime(t) : model.modelData.time;

                var classesThisWeek = 1;
                if (myMeeting.counselor3 && myMeeting.classes === 3)
                    classesThisWeek = 3;
                else if (myMeeting.counselor2 && myMeeting.classes > 1)
                    classesThisWeek = 2;
                if (model.modelData.meetingPart !== MeetingPart.Service_Talk &&
                        (noMultiSchool || !model.modelData.canMultiSchool || model.modelData.classnumber === classesThisWeek))
                    t.setMinutes(t.getMinutes() + model.modelData.time + (model.modelData.canCounsel ? 1 : 0));
            }

            Column {
                id: gridLayout

                width: parent.width
                spacing: 0

                // section separator
                Rectangle {
                    width: parent.width
                    height: Material.delegateHeight / 3
                    color: Material.background
                    visible: hdr && model.index > 0
                }

                RowLayout {
                    width: parent.width
                    Rectangle {
                        color: hdr_text_color
                        height: Material.delegateHeight
                        width: Material.delegateHeight
                        visible: hdr
                        InterimIcon {
                            id: rowIcon
                            anchors.fill: parent
                            anchors.margins: 4
                            color: Material.background
                        }
                    }
                    // header for meeting part
                    Item {
                        Layout.fillWidth: true
                        height: Material.delegateHeight
                        visible: hdr

                        Label {
                            id: headerText
                            anchors.fill: parent
                            verticalAlignment: Text.AlignVCenter
                            horizontalAlignment: Text.AlignLeft
                            font: TBStyle.titleLargeFont
                            color: hdr_text_color
                            elide: Text.ElideRight
                        }
                    }
                }
                // song row
                ScheduleRowItem {
                    id: songRow
                    height: Material.delegateHeight
                    width: parent.width
                    timeColor: showTime ? Material.background : TBStyle.lmmSection3TextColor
                    timeBackgroundColor: showTime ? TBStyle.lmmSection3TextColor : "transparent"
                    themeText: qsTr("Song") + " " + myMeeting.songMiddle.toString() +
                                    (settings_ui.showSongTitles ? "\n" + myMeeting.songMiddleTitle : "")
                    themeColor: TBStyle.mediumColor
                    visible: hdr && model.modelData.assignmentInfo && model.modelData.assignmentInfo.meetingSection === MeetingSection.LivingAsChristians
                }

                ScheduleRowItem {
                    id: themeRow
                    height: Material.delegateHeight
                    width: parent.width
                    timeColor: Material.background
                    timeBackgroundColor: hdr_text_color
                    themeText: model.modelData.theme
                    themeColor: tabView.currentIndex > 0 && model.modelData.classnumber === 1 ? TBStyle.mediumColor : Material.foreground
                    nameText1.text: model.modelData.volunteer ? ">" + model.modelData.volunteer.fullName : model.modelData.speakerFullName +
                                                                (model.modelData.meetingPart === MeetingPart.LMM_CBS ? " (" + qsTr("Conductor") + ")" : "")
                    nameText2.text: !model.modelData.assistant ? "" : model.modelData.assistant.fullName +
                                                                 (model.modelData.meetingPart === MeetingPart.LMM_CBS ? " (" + qsTr("Reader") + ")" : "")
                    nameText2.color: TBStyle.mediumColor
                    imageSource: clickable ? "qrc:/icons/chevron_right.svg" : ""
                    clickable: canEditMidweekMeetingSchedule && editpossible
                    onClicked: {
                        console.log("Row clicked!")
                        editButtonClicked(index)
                    }
                }
            }
        }
    }
}

