import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Layouts

Pane {
    id: control
    enum BoxSize {
        Small,
        Normal
    }
    property int boxSize: InfoBox.BoxSize.Small
    property string backgroundColor: Material.accent
    property string text: ""
    property string textColor: Material.foreground
    property int horizontalAlignment: Text.AlignHCenter
    property int maxWidth: boxSize === InfoBox.BoxSize.Normal ? 24 : 20
    property int pointSize: Qt.application.font.pointSize

    Material.theme: Material.System
    Material.roundedScale: Material.ExtraSmallScale

    implicitHeight: (boxSize === InfoBox.BoxSize.Normal ? 24 : 20) + topInset + bottomInset
    implicitWidth: Math.max(height, contentWidth + leftPadding + rightPadding,
                            implicitBackgroundWidth + leftInset + rightInset,
                            infoText.paintedWidth + leftPadding + rightPadding)

    topInset: 8
    bottomInset: 8
    leftInset: 8
    rightInset: 8

    leftPadding: 10
    rightPadding: 10

    hoverEnabled: false

    background: Rectangle {
        opacity: enabled ? 1 : 0.3
        color: parent.backgroundColor
        radius: control.Material.roundedScale
    }

    contentItem: RowLayout {
        Item {
            implicitWidth: Math.max(control.maxWidth, infoText.implicitWidth)
            implicitHeight: infoText.implicitHeight + 5
            Layout.maximumWidth: Math.max(control.maxWidth, infoText.maxWidth)
            Layout.fillWidth: true
            Layout.fillHeight: true

            Text {
                property alias maxWidth: dummy.implicitWidth //control.maxWidth
                id: infoText

                text: control.text

                anchors.fill: parent
                anchors.centerIn: parent
                anchors.margins: 0 //2.5
                horizontalAlignment: control.horizontalAlignment
                verticalAlignment: Text.AlignVCenter
                font.pointSize: control.pointSize
                color: control.textColor

                Text {
                    id: dummy
                    text: control.text
                    font.pointSize: control.pointSize
                    color: control.textColor
                    visible: false
                }
            }
        }
    }
}

/*##^##
Designer {
    D{i:0;autoSize:true;height:480;width:640}
}
##^##*/

