// Copyright (C) 2019 Julian Sherollari <jdotsh@gmail.com>
// Copyright (C) 2019 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause

import QtQuick
import QtPositioning
import QtLocation

//! [DelegateChooser]
DelegateChooser {
    id: dc
    role: "type"
//! [DelegateChooser]
    property color defaultColor: "#46a2da"
    property int defaultLineWidth: 2
    property real defaultOpacity: 0.6

    //! [DelegateChoice Point]
    DelegateChoice {
        roleValue: "Point"
        delegate: MapCircle {
            property string geojsonType: "Point"
            property var props: modelData.properties
            geoShape: modelData.data
            radius: (props && props.radius) || 20*1000
            border.width: 2
            border.color: hh.hovered ? "magenta" : color //Qt.darker(color)
            opacity: dc.defaultOpacity
            color: (props && props.color) || (parent && parent.props && parent.props.color) || dc.defaultColor
    //! [DelegateChoice Point]
            autoFadeIn: sketchLayer.autoFadeIn
            referenceSurface: sketchLayer.referenceSurface

            //! [Handler Point]
            TapHandler {
                onTapped: {
                    if (props !== undefined)
                        console.log(props.name)
                    else if (parent.parent.geojsonType == "MultiPoint")
                        console.log(parent.parent.props.name)
                    else
                        console.log("NO NAME (Point)!", props)
                }
            }
            HoverHandler {
                id: hh
            }
            //! [Handler Point]
    //! [DelegateChoice Point1]
        }
    }
    //! [DelegateChoice Point1]

    DelegateChoice {
        roleValue: "LineString"
        delegate: MapPolyline {
            property string geojsonType: "LineString"
            property var props: modelData.properties
            geoShape: modelData.data
            line.width: dc.defaultLineWidth
            opacity: dc.defaultOpacity
            line.color: hh.hovered ? dc.defaultColor : (props && props.color) || (parent && parent.props && parent.props.color) || dc.defaultColor
            autoFadeIn: sketchLayer.autoFadeIn
            referenceSurface: sketchLayer.referenceSurface

            TapHandler {
                onTapped: {
                    if (sketchLayer.ink === 0
                            && (sketchPointHandler.point.pressedButtons || sketchPointHandler.active)) {
                        // delete item when eraser is selected and pen or mouse button pressed
                        // or activated via finger touch
                        sketchLayer.deleteSketchItem(modelData);
                    }
                }
            }
            HoverHandler {
                id: hh

                acceptedDevices: PointerDevice.AllDevices
                onHoveredChanged: {
                    if (sketchLayer.ink === 0
                            && (sketchPointHandler.point.pressedButtons || sketchPointHandler.active)) {
                        // delete item when eraser is selected and pen or mouse button pressed
                        // or activated via finger touch
                        sketchLayer.deleteSketchItem(modelData);
                    }
                }
            }
        }
    }

    DelegateChoice {
        roleValue: "Polygon"
        delegate: MapPolygon {
            property string geojsonType: "Polygon"
            property var props: modelData.properties
            geoShape: modelData.data
            opacity: dc.defaultOpacity
            color: (props && props.color) || (parent && parent.props && parent.props.color) || dc.defaultColor
            border.width: 2
            border.color: hh.hovered ? "magenta" : Qt.darker(color)
            autoFadeIn: sketchLayer.autoFadeIn
            referenceSurface: sketchLayer.referenceSurface

            TapHandler {
                onTapped: {
                    if (props !== undefined)
                        console.log(props.name)
                    else if (parent.parent.geojsonType == "MultiPolygon")
                        console.log(parent.parent.props.name)
                    else
                        console.log("NO NAME (Polygon)!", props)
                }
            }
            HoverHandler {
                id: hh
            }
        }
    }

    DelegateChoice {
        roleValue: "MultiPoint"
        delegate: MapItemView {
            property string geojsonType: "MultiPoint"
            property var props: modelData.properties
            model: modelData.data
            delegate: dc
        }
    }

    DelegateChoice {
        roleValue: "MultiLineString"
        delegate: MapItemView {
            property string geojsonType: "MultiLineString"
            property var props: modelData.properties
            model: modelData.data
            delegate: dc
        }
    }

    DelegateChoice {
        roleValue: "MultiPolygon"
        delegate: MapItemView {
            property string geojsonType: "MultiPolygon"
            property var props: modelData.properties
            model: modelData.data
            delegate: dc
        }
    }

    DelegateChoice {
        roleValue: "GeometryCollection"
        delegate: MapItemView {
            property string geojsonType: "GeometryCollection"
            property var props: modelData.properties
            model: modelData.data
            delegate: dc
        }
    }

    // Features are explicitly not generated by the parser, but converted straight to their content + the properties.

    DelegateChoice {
        roleValue: "FeatureCollection"
        delegate: MapItemView {
            property string geojsonType: "FeatureCollection"
            property var props: modelData.properties
            model: modelData.data
            delegate: dc
        }
    }
//! [DelegateChooser1]
}
//! [DelegateChooser1]
