import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Layouts
import net.theocbase.mobile 1.0
import net.theocbase 1.0

GroupBox {
    id: control

    Material.background: myPalette.alternateBase
    Material.containerStyle: Material.Filled
    Material.roundedScale: Material.LargeScale

    SystemPalette { id: myPalette; colorGroup: SystemPalette.Active }

    label: Label {
        x: control.leftPadding
        width: control.availableWidth
        leftPadding: 16
        text: control.title
        font: TBStyle.titleSmallFont
        color: TBStyle.mediumColor
        elide: Text.ElideRight
    }

    background: Rectangle {
        y: control.topPadding - control.bottomPadding
        width: parent.width
        height: parent.height - control.topPadding + control.bottomPadding
        color: control.Material.background
        border.color: "transparent"
        radius: Material.MediumScale
    }
}
