/**
 * This file is part of TheocBase.
 *
 * Copyright (C) 2011-2019, TheocBase Development Team, see AUTHORS.
 *
 * TheocBase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * TheocBase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TheocBase.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Window
import QtQuick.Dialogs
import net.theocbase.mobile 1.0

Page {
    id: pageRect

    header: BaseToolbar {
        title: "Debug"
        componentLeft: ToolButton {
            icon.source: "qrc:/icons/back.svg"
            onClicked: { stackView.pop() }
        }
    }

    ScrollView {
        id: flickable1
        anchors.fill: parent
        contentWidth: parent.width

        Pane {
            id: layout
            width: parent.width
            Column {
                spacing: 16
                width: parent.width

                FilledGroupBox {
                    width: parent.width
                    title: "Debug information"

                    Column {
                        width: parent.width
                        RowText {
                            width: parent.width
                            title: "Operating System"
                            text: Qt.platform.os
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowText {
                            width: parent.width
                            title: "Screen size inch"
                            text: app_info.screensize.toFixed(1)
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowText {
                            width: parent.width
                            title: "Screen size"
                            text: Screen.width.toString() + "x" + Screen.height.toString()
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowText {
                            width: parent.width
                            title: "Screen available size"
                            text: Screen.desktopAvailableWidth.toString() + "x" + Screen.desktopAvailableHeight.toString()
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowText {
                            width: parent.width
                            title: "Pixel density"
                            //visible: textareatest.visible
                            text: Screen.pixelDensity.toString()
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowText {
                            width: parent.width
                            title: "Device Pixel Ratio"
                            text: app_info.devicepixelratio.toString()
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowText {
                            width: parent.width
                            title: "Default font pixel size"
                            text: app_info.fontpixels.toString()
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowText {
                            width: parent.width
                            title: "Default font point size"
                            text: app_info.fontsizepoint.toString()
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowText {
                            width: parent.width
                            title: "Font size normal"
                            text: TBStyle.bodyMediumFont.pointSize
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowText {
                            width: parent.width
                            title: "Font size small"
                            text: TBStyle.bodySmallFont.pointSize
                        }
                        MenuSeparator { width: parent.width; padding: 0 }
                        RowText {
                            width: parent.width
                            title: "UI Languages"
                            text: app_info.uilanguages
                        }
                    }
                }
                FilledGroupBox {
                    width: parent.width
                    title: "Backup file"

                    ToolButton {
                        width: parent.width
                        text: "Share backup file"
                        onClicked: {
                            shareUtils.saveBackup()
                        }
                    }
                }
                FilledGroupBox {
                    width: parent.width
                    title: "Import"

                    ToolButton {
                        width: parent.width
                        text: "Import epub file"
                        onClicked: {
                            shareUtils.openFile("epub")
                        }
                    }
                }
            }
        }
    }
}

