import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Material
import QtQuick.Layouts
import net.theocbase.mobile 1.0

ToolBar {
    property alias componentLeft: loaderLeft.sourceComponent
    property alias componentLeftVisible: loaderLeft.visible
    property alias componentLeftMiddle: loaderLeftMiddle.sourceComponent
    property alias componentLeftMiddleVisible: loaderLeftMiddle.visible
    property alias componentMiddle: loaderMiddle.sourceComponent
    property alias componentRightMiddle: loaderRightMiddle.sourceComponent
    property alias componentRightMiddleVisible: loaderRightMiddle.visible
    property alias componentRight: loaderRight.sourceComponent
    property alias componentRightVisible: loaderRight.visible

    property string title
    property string subtitle
    property color titleColor: TBStyle.onPrimaryColor
    property bool showBorderLine: true

    Material.foreground: titleColor

    leftPadding: parent.leftPadding
    rightPadding: parent.rightPadding

    RowLayout {
        id: row
        anchors.fill: parent

        Loader {
            id: loaderLeft
            Layout.fillHeight: true
            // Layout.fillWidth: true
            sourceComponent: defaultComp
            // Layout.preferredWidth: parent.height
        }
        Loader {
            id: loaderLeftMiddle
            Layout.fillHeight: true
            // Layout.preferredWidth: parent.height
        }
        Loader {
            id: loaderMiddle
            Layout.fillHeight: true
            Layout.fillWidth: true
            sourceComponent: defaultLabel
        }
        Loader {
            id: loaderRightMiddle
            Layout.fillHeight: true
            // Note: this place can contain more than just one item
            // Layout.preferredWidth: parent.height
        }
        Loader {
            id: loaderRight
            Layout.fillHeight: true
            // Layout.fillWidth: true
            sourceComponent: defaultComp
            // Note: this place can contain more than just one item
            // Layout.preferredWidth: parent.height
        }
    }

    Component {
        id: defaultLabel

        ColumnLayout {
            Item {
                Layout.fillHeight: true
            }
            Label {
                Layout.fillWidth: true
                Layout.alignment: Qt.AlignVCenter
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
                text: title
                font: TBStyle.titleMediumFont
                color: titleColor
                renderType: Text.QtRendering
                elide: Text.ElideMiddle
            }
            Label {
                Layout.fillWidth: true
                Layout.alignment: Qt.AlignVCenter
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
                visible: subtitle
                text: subtitle
                font: TBStyle.titleSmallFont
                color: titleColor
                renderType: Text.QtRendering
                elide: Text.ElideMiddle
            }
            Item {
                Layout.fillHeight: true
            }
        }
    }
    Component {
        id: defaultComp
        Item { implicitWidth: 20 }
    }
}
