#ifndef importlmmworkbook_H
#define importlmmworkbook_H

#include <QEventLoop>
#include <QTimer>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkReply>
#include <QString>
#include <QFile>
#include <QMap>
#include <QRegularExpression>
#include <QXmlStreamReader>
#include <QDate>
#include <QTextStream>
#include <iostream>
#include <QJsonDocument>
#include <QJsonArray>
#include <QJsonObject>
#include <QDomDocument>
#include <QPair>
#include <QDebug>
#include <QStringView>
#include "epub.h"
#include "lmm_meeting.h"
#include "lmm_schedule.h"
#include "xml_reader.h"
#include "sql_class.h"
#include "sharedlib_global.h"

class TB_EXPORT importlmmworkbook : public QObject
{
    Q_OBJECT

public:
    explicit importlmmworkbook(QObject *parent = nullptr);
    importlmmworkbook(QString fileName);
    importlmmworkbook(QString fileName, QString language, bool debugMode);
    importlmmworkbook(QString fileName, bool usePDFLangCode); // debug mode (see lmmworksheetregex)
    ~importlmmworkbook();
    Q_INVOKABLE QString getWtLocale(QString languageCode);
    Q_INVOKABLE QString getDocumentId(QDate date);
    QString Import();
    Q_INVOKABLE QString importHtml(QString url, QString html);
    Q_INVOKABLE QString importFile(const QString fileName);
    void ImportDate(QDate dt, QString href, QString chapter);
    bool DownloadAssistDoc(QDate sampleDate);

    enum xmlPartsContexts {
        tocEntry,
        languageCode,
        body,
        bibleReading,
        bibleReadingDetail,
        header,
        section1,
        talk,
        bodyTxt
    };
    Q_ENUM(xmlPartsContexts)

    enum foundParts {
        biblereading = 0,
        opensong,
        treasures,
        digging,
        br,
        fm1,
        fm2,
        fm3,
        fm4,
        fm5,
        fm6,
        midsong,
        talk1,
        talk2,
        talk3,
        talk4,
        talk5,
        endsong,
        lastItem = endsong
    };
    Q_ENUM(foundParts)

    enum rxLoadStates {
        noLoadAttempt,
        attempted,
        loaded
    };

    QHash<QString, QString> regexes;
    QStringList tocEntries;
    QList<QDate *> tocEntriesDate;
    QStringList tocEntriesHTML;
    QStringList meetingResults;
    QHash<QString, QString> newSettingValues;
    epub epb;
    bool prepared;

public slots:
    void xmlPartFound(QXmlStreamReader *xml, QXmlStreamReader::TokenType tokenType, int context, int relativeDepth);
    void ProcessTOCEntry(QString href, QString chapter);
    void ProcessCoverImage(QString fileName);

private:
    enum ScheduleTerm {
        StartingConversation = 1,
        FollowingUp,
        MakingDisciples,
        ExplainingYourBeliefs,
        Talk,
        Demonstration,
        Discussion,
        Video,
    };
    Q_ENUM(ScheduleTerm)

    void Init(QString fileName);
    void InsertSchedule(int talkId, int sequence, int rownumber, QDate date, QString theme, QString source1, QString source2, int time, QString studyTex);
    QString cleanText(QString text);
    void getTalkIdIndex(QDate date, int (&index)[15]);
    void saveTalkIndex(QDate dt, int (&talkid_index)[15]);
    QString resultText(int year);
    void fillDocumentIds(int year);
    QDate getDocumentDate(QString documentId, MeetingType meetingType);
    void LoadRegex(QString langCode = "", QString libraryLangCode = "");
    QString readRuby(QXmlStreamReader *xml);
    QString readInnerText(QXmlStreamReader *xml);

    sql_class *sql;
    bool debugMode;
    QString forcedLanguage;
    int year;
    int month;
    QString lastError;

    QString firstDate;
    QString lastDate;
    int validDates;
    QDate nullDate;
    QDate dtBeingImported;
    int rxLoadState;
    QRegularExpression rxSong;
    QRegularExpression rxTiming;
    QRegularExpression invisibleCharacters; // to remove characters such as 'soft hyphen' or 'zero width space', which may prevent string comparison

    int epubliIdx;
    int currentTalkPid;
    int epubSectionOffset = 0;
    QStringList epubResults;
    int ignoreTextContext;
    int ignoreTextDepth;
    QString htmldata = "";

    QHash<QDate, QString> mwbDocumentIds;
    QHash<int, QString> scheduleTerms;
};

#endif // importlmmworkbook_H
