#ifndef DATAOBJECT_H
#define DATAOBJECT_H

#include <QObject>
#include <QAbstractListModel>
#include <QSortFilterProxyModel>

class DataObject
{
public:
    DataObject(const int &id, const QString &name);
    DataObject(const int &id, const QString &name, const QString &color);
    DataObject(const int &id, const QString &name, const QString &color, const bool isValid);

    int id() const;
    QString name() const;
    QString color() const;
    bool isValid() const;

private:
    int m_id;
    QString m_name;
    QString m_color;
    bool m_isValid;
};

// Q_DECLARE_METATYPE(DataObject*)

class DataObjectListModel : public QAbstractListModel
{
    Q_OBJECT
public:
    enum DataObjectRoles {
        IdRole = Qt::UserRole + 1,
        NameRole,
        ColorRole,
        IsValid
    };
    Q_ENUM(DataObjectRoles)

    DataObjectListModel(QObject *parent = nullptr);
    QHash<int, QByteArray> roleNames() const;

    void addDataObject(const DataObject &dataObject);
    Q_INVOKABLE void addDataObject(const int &id, const QString &name, const QString &color, const bool isValid);

    int rowCount(const QModelIndex &parent = QModelIndex()) const;

    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;

    Q_INVOKABLE QVariantMap get(int row);

    Q_INVOKABLE int getId(int index) const;
    Q_INVOKABLE int getIndex(int id) const;
    Q_INVOKABLE int getIndex(QString name) const;

private:
    QList<DataObject> m_dataObjects;
};

// Q_DECLARE_METATYPE(DataObjectListModel*)

class DataObjectListSortFilterProxyModel : public QSortFilterProxyModel
{
    Q_OBJECT
    Q_PROPERTY(QObject *source READ source WRITE setSource NOTIFY sourceChanged)
    Q_PROPERTY(QString filterText READ filterText WRITE setFilterText NOTIFY filterTextChanged)
    Q_PROPERTY(QByteArray sortRole READ sortRole WRITE setSortRole NOTIFY sortChanged)
    Q_PROPERTY(QByteArray groupByRole READ groupByRole WRITE setGroupByRole NOTIFY groupByChanged)

public:
    DataObjectListSortFilterProxyModel(QObject *parent = nullptr);

    QObject *source() const;
    void setSource(QObject *source);

    QString filterText() const;
    void setFilterText(QString newValue);

    QByteArray sortRole() const;
    void setSortRole(const QByteArray &role);

    QByteArray groupByRole() const;
    void setGroupByRole(const QByteArray &role);

    Q_INVOKABLE virtual void sort(int column, Qt::SortOrder order = Qt::AscendingOrder) override
    {
        QSortFilterProxyModel::sort(column, order);
    }

protected:
    bool filterAcceptsRow(int sourceRow, const QModelIndex &sourceParent) const override;
    bool lessThan(const QModelIndex &left, const QModelIndex &right) const override;
    int roleKey(const QByteArray &role) const;

private:
    QString m_filterText;
    QByteArray m_groupByRole;

signals:
    void sourceChanged();
    void filterTextChanged();
    void sortChanged();
    void groupByChanged();
};

#endif // DATAOBJECT_H
